/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.graphdb.index.UniqueFactory;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.transaction.SpringTransactionManager;
import org.neo4j.tooling.GlobalGraphOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.support.index.IndexType;
import org.springframework.data.neo4j.support.index.NoSuchIndexException;
import org.springframework.data.neo4j.support.query.ConversionServiceQueryResultConverter;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;
import org.springframework.data.neo4j.support.query.QueryEngine;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class DelegatingGraphDatabase
implements GraphDatabase {
    private static final Logger log = LoggerFactory.getLogger(DelegatingGraphDatabase.class);
    protected GraphDatabaseService delegate;
    private ConversionService conversionService;
    private ResultConverter resultConverter;
    private volatile QueryEngine<Object> cypherQueryEngine;
    private long referenceNode = -2L;

    public DelegatingGraphDatabase(GraphDatabaseService delegate) {
        this(delegate, null);
    }

    public DelegatingGraphDatabase(GraphDatabaseService delegate, ResultConverter resultConverter) {
        this.delegate = delegate;
        this.resultConverter = resultConverter;
    }

    @Override
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public void setResultConverter(ResultConverter resultConverter) {
        this.resultConverter = resultConverter;
        this.reinitQueryEngines();
    }

    private void reinitQueryEngines() {
        if (this.cypherQueryEngine != null) {
            this.cypherQueryEngine = this.queryEngineFor(QueryType.Cypher, this.resultConverter, true);
        }
    }

    @Override
    public Node getNodeById(long id) {
        return this.delegate.getNodeById(id);
    }

    @Override
    public Node createNode(Map<String, Object> props) {
        return this.setProperties(this.delegate.createNode(), props);
    }

    private <T extends PropertyContainer> T setProperties(T primitive, Map<String, Object> properties) {
        assert (primitive != null);
        if (properties == null || properties.isEmpty()) {
            return primitive;
        }
        for (Map.Entry<String, Object> prop : properties.entrySet()) {
            if (prop.getValue() == null) {
                primitive.removeProperty(prop.getKey());
                continue;
            }
            primitive.setProperty(prop.getKey(), prop.getValue());
        }
        return primitive;
    }

    private void removeFromIndexes(Node node) {
        IndexManager indexManager = this.delegate.index();
        for (String indexName : indexManager.nodeIndexNames()) {
            Index nodeIndex = indexManager.forNodes(indexName);
            if (!nodeIndex.isWriteable()) continue;
            nodeIndex.remove((PropertyContainer)node);
        }
    }

    private void removeFromIndexes(Relationship relationship) {
        IndexManager indexManager = this.delegate.index();
        for (String indexName : indexManager.relationshipIndexNames()) {
            RelationshipIndex relationshipIndex = indexManager.forRelationships(indexName);
            if (!relationshipIndex.isWriteable()) continue;
            relationshipIndex.remove((PropertyContainer)relationship);
        }
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return this.delegate.getRelationshipById(id);
    }

    @Override
    public Relationship createRelationship(Node startNode, Node endNode, RelationshipType type, Map<String, Object> properties) {
        return this.setProperties(startNode.createRelationshipTo(endNode, type), properties);
    }

    @Override
    public <T extends PropertyContainer> Index<T> getIndex(String indexName) {
        IndexManager indexManager = this.delegate.index();
        if (indexManager.existsForNodes(indexName)) {
            return indexManager.forNodes(indexName);
        }
        if (indexManager.existsForRelationships(indexName)) {
            return indexManager.forRelationships(indexName);
        }
        throw new NoSuchIndexException(indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends PropertyContainer> Index<T> createIndex(Class<T> type, String indexName, IndexType indexType) {
        Transaction tx = this.delegate.beginTx();
        try {
            IndexManager indexManager = this.delegate.index();
            if (this.isNode(type)) {
                Index index;
                if (indexManager.existsForNodes(indexName)) {
                    Index<T> index2 = this.checkAndGetExistingIndex(indexName, indexType, indexManager.forNodes(indexName));
                    return index2;
                }
                Index index3 = index = indexManager.forNodes(indexName, this.indexConfigFor(indexType));
                return index3;
            }
            if (indexManager.existsForRelationships(indexName)) {
                Index<T> index = this.checkAndGetExistingIndex(indexName, indexType, (Index<T>)indexManager.forRelationships(indexName));
                return index;
            }
            RelationshipIndex relationshipIndex = indexManager.forRelationships(indexName, this.indexConfigFor(indexType));
            return relationshipIndex;
        }
        finally {
            tx.success();
            tx.close();
        }
    }

    public boolean isNode(Class<? extends PropertyContainer> type) {
        if (type.equals(Node.class)) {
            return true;
        }
        if (type.equals(Relationship.class)) {
            return false;
        }
        throw new IllegalArgumentException("Unknown Graph Primitive, neither Node nor Relationship" + type);
    }

    private <T extends PropertyContainer> Index<T> checkAndGetExistingIndex(String indexName, IndexType indexType, Index<T> index) {
        Map existingConfig = this.delegate.index().getConfiguration(index);
        Map<String, String> config = this.indexConfigFor(indexType);
        if (this.configCheck(config, existingConfig, "provider") && this.configCheck(config, existingConfig, "type")) {
            return index;
        }
        throw new IllegalArgumentException("Setup for index " + indexName + " does not match. Existing: " + existingConfig + " required " + config);
    }

    private boolean configCheck(Map<String, String> config, Map<String, String> existingConfig, String setting) {
        return ObjectUtils.nullSafeEquals((Object)config.get(setting), (Object)existingConfig.get(setting));
    }

    private Map<String, String> indexConfigFor(IndexType indexType) {
        return indexType.getConfig();
    }

    @Override
    public TraversalDescription traversalDescription() {
        return Traversal.description();
    }

    @Override
    public <T> QueryEngine<T> queryEngineFor(QueryType type) {
        return this.queryEngineFor(type, this.createResultConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> QueryEngine<T> queryEngineFor(QueryType type, ResultConverter resultConverter, boolean reinit) {
        switch (type) {
            case Cypher: {
                if (reinit || this.cypherQueryEngine == null) {
                    DelegatingGraphDatabase delegatingGraphDatabase = this;
                    synchronized (delegatingGraphDatabase) {
                        if (reinit || this.cypherQueryEngine == null) {
                            this.cypherQueryEngine = this.createCypherQueryEngine(resultConverter);
                        }
                    }
                }
                return this.cypherQueryEngine;
            }
        }
        throw new IllegalArgumentException("Unknown Query Engine Type " + (Object)((Object)type));
    }

    @Override
    public <T> QueryEngine<T> queryEngineFor(QueryType type, ResultConverter resultConverter) {
        return this.queryEngineFor(type, resultConverter, false);
    }

    private <T> QueryEngine<T> createCypherQueryEngine(ResultConverter resultConverter) {
        if (!ClassUtils.isPresent((String)"org.neo4j.cypher.javacompat.ExecutionEngine", (ClassLoader)this.getClass().getClassLoader())) {
            return new FailingQueryEngine("Cypher");
        }
        return new CypherQueryEngine(this.delegate, resultConverter);
    }

    @Override
    public boolean transactionIsRunning() {
        if (!(this.delegate instanceof GraphDatabaseAPI)) {
            return true;
        }
        try {
            TransactionManager txManager = (TransactionManager)((GraphDatabaseAPI)this.delegate).getDependencyResolver().resolveDependency(TransactionManager.class);
            return txManager.getStatus() != 6;
        }
        catch (SystemException e) {
            log.error("Error accessing TransactionManager", (Throwable)e);
            return false;
        }
    }

    @Override
    public TransactionManager getTransactionManager() {
        return new SpringTransactionManager((GraphDatabaseAPI)this.delegate);
    }

    @Override
    public Transaction beginTx() {
        return this.delegate.beginTx();
    }

    @Override
    public void remove(Node node) {
        this.removeFromIndexes(node);
        node.delete();
    }

    @Override
    public void remove(Relationship relationship) {
        this.removeFromIndexes(relationship);
        relationship.delete();
    }

    private ResultConverter createResultConverter() {
        if (this.resultConverter != null) {
            return this.resultConverter;
        }
        this.resultConverter = this.conversionService != null ? new ConversionServiceQueryResultConverter(this.conversionService) : new DefaultConverter();
        return this.resultConverter;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public Collection<String> getAllLabelNames() {
        HashSet<String> labels = new HashSet<String>();
        for (Label label : GlobalGraphOperations.at((GraphDatabaseService)this.delegate).getAllLabels()) {
            labels.add(label.name());
        }
        return labels;
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.delegate;
    }

    @Override
    public Node getOrCreateNode(String indexName, String key, Object value, final Map<String, Object> nodeProperties) {
        if (indexName == null || key == null || value == null) {
            throw new IllegalArgumentException("Unique index " + indexName + " key " + key + " value must not be null");
        }
        if (value instanceof Number) {
            value = ValueContext.numeric((Number)((Number)value));
        }
        UniqueFactory.UniqueNodeFactory factory = new UniqueFactory.UniqueNodeFactory(this.delegate, indexName){

            protected void initialize(Node node, Map<String, Object> _) {
                DelegatingGraphDatabase.this.setProperties((PropertyContainer)node, nodeProperties);
            }
        };
        return (Node)factory.getOrCreate(key, value);
    }

    @Override
    public Relationship getOrCreateRelationship(String indexName, String key, Object value, final Node startNode, final Node endNode, final String type, final Map<String, Object> properties) {
        if (indexName == null || key == null || value == null) {
            throw new IllegalArgumentException("Unique index " + indexName + " key " + key + " value must not be null");
        }
        if (startNode == null || endNode == null || type == null) {
            throw new IllegalArgumentException("StartNode " + startNode + " EndNode " + endNode + " and type " + type + " must not be null");
        }
        if (value instanceof Number) {
            value = ValueContext.numeric((Number)((Number)value));
        }
        UniqueFactory.UniqueRelationshipFactory factory = new UniqueFactory.UniqueRelationshipFactory(this.delegate, indexName){

            protected Relationship create(Map<String, Object> _) {
                Relationship relationship = startNode.createRelationshipTo(endNode, (RelationshipType)DynamicRelationshipType.withName((String)type));
                return (Relationship)DelegatingGraphDatabase.this.setProperties((PropertyContainer)relationship, properties);
            }
        };
        return (Relationship)factory.getOrCreate(key, value);
    }

    private static class FailingQueryEngine<T>
    implements QueryEngine<T> {
        private String dependency;

        private FailingQueryEngine(String dependency) {
            this.dependency = dependency;
        }

        @Override
        public Result<T> query(String statement, Map<String, Object> params) {
            throw new IllegalStateException(this.dependency + " is not available, please add it to your dependencies to execute: " + statement);
        }
    }
}

