/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.fieldaccess.ConvertingNodePropertyFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.fieldaccess.PropertyFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;

public class SchemaIndexingPropertyFieldAccessorListenerFactory<S extends PropertyContainer, T>
implements FieldAccessorListenerFactory {
    private final PropertyFieldAccessorFactory propertyFieldAccessorFactory;
    private final ConvertingNodePropertyFieldAccessorFactory convertingNodePropertyFieldAccessorFactory;
    private final Neo4jTemplate template;

    public SchemaIndexingPropertyFieldAccessorListenerFactory(Neo4jTemplate template, PropertyFieldAccessorFactory propertyFieldAccessorFactory, ConvertingNodePropertyFieldAccessorFactory convertingNodePropertyFieldAccessorFactory) {
        this.template = template;
        this.propertyFieldAccessorFactory = propertyFieldAccessorFactory;
        this.convertingNodePropertyFieldAccessorFactory = convertingNodePropertyFieldAccessorFactory;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        return this.isPropertyField(property) && property.isIndexed() && property.getIndexInfo().isLabelBased();
    }

    private boolean isPropertyField(Neo4jPersistentProperty property) {
        return this.propertyFieldAccessorFactory.accept(property) || this.convertingNodePropertyFieldAccessorFactory.accept(property);
    }

    @Override
    public FieldAccessListener forField(Neo4jPersistentProperty property) {
        return new SchemaIndexingPropertyFieldAccessorListener(property, this.template);
    }

    public static class SchemaIndexingPropertyFieldAccessorListener<T extends PropertyContainer>
    implements FieldAccessListener {
        private static final Logger log = LoggerFactory.getLogger(SchemaIndexingPropertyFieldAccessorListener.class);
        private final Neo4jPersistentProperty property;
        private final Neo4jTemplate template;

        public SchemaIndexingPropertyFieldAccessorListener(Neo4jPersistentProperty property, Neo4jTemplate template) {
            this.property = property;
            this.template = template;
        }

        @Override
        public void valueChanged(Object entity, Object oldVal, Object newVal) {
            Object state = this.template.getPersistentState(entity);
            if (state instanceof Node) {
                Node node = (Node)state;
                StoredEntityType set = this.template.getStoredEntityType(entity);
                if (set != null) {
                    this.applyMissingSchemaIndexLabels(node, set);
                }
            }
        }

        private void applyMissingSchemaIndexLabels(Node node, StoredEntityType set) {
            for (StoredEntityType ancestorSet : set.getSuperTypes()) {
                this.applyMissingSchemaIndexLabels(node, ancestorSet);
            }
            Label label = DynamicLabel.label((String)((String)set.getAlias()));
            if (!node.hasLabel(label)) {
                node.addLabel(label);
            }
        }
    }
}

