/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.ManagedFieldAccessorSet;
import org.springframework.data.neo4j.fieldaccess.RelationshipHelper;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public abstract class RelatedToFieldAccessor
implements FieldAccessor {
    protected final RelationshipType type;
    protected final Neo4jPersistentProperty property;
    protected final Direction direction;
    protected final Class<?> relatedType;
    protected final Neo4jTemplate template;
    protected RelationshipHelper relationshipHelper;

    public RelatedToFieldAccessor(Class<?> relatedType, Neo4jTemplate template, Direction direction, RelationshipType type, Neo4jPersistentProperty property) {
        this.relationshipHelper = new RelationshipHelper(template, direction, type);
        this.relatedType = relatedType;
        this.template = template;
        this.direction = direction;
        this.type = type;
        this.property = property;
    }

    @Override
    public boolean isWriteable(Object entity) {
        return true;
    }

    protected <T> ManagedFieldAccessorSet<T> createManagedSet(Object entity, Set<T> result, MappingPolicy mappingPolicy) {
        return ManagedFieldAccessorSet.create(entity, result, mappingPolicy, this.property, this.template, this);
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    protected Node checkAndGetNode(Object entity) {
        return this.relationshipHelper.checkAndGetNode(entity);
    }

    protected void removeMissingRelationships(Node node, Set<Node> targetNodes) {
        this.removeMissingRelationships(node, targetNodes, null);
    }

    protected void removeMissingRelationships(Node node, Set<Node> targetNodes, Class targetType) {
        this.relationshipHelper.removeMissingRelationshipsInStoreAndKeepOnlyNewRelationShipsInSet(node, targetNodes, targetType);
    }

    protected void createAddedRelationships(Node node, Set<Node> targetNodes) {
        this.relationshipHelper.createAddedRelationships(node, targetNodes);
    }

    protected Set<Node> createSetOfTargetNodes(Object newVal) {
        return this.relationshipHelper.createSetOfTargetNodes(newVal, this.relatedType);
    }

    protected Set<Object> createEntitySetFromRelationshipEndNodes(Object entity, MappingPolicy mappingPolicy) {
        return this.relationshipHelper.createEntitySetFromRelationshipEndNodes(entity, mappingPolicy, this.relatedType);
    }

    protected Set<Object> createEntitySetFromRelationshipEndNodesUsingTypeProperty(Object entity, MappingPolicy mappingPolicy) {
        return this.relationshipHelper.createEntitySetFromRelationshipEndNodes(entity, mappingPolicy, null);
    }
}

