/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.index.lucene.ValueContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.neo4j.fieldaccess.ConvertingNodePropertyFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.fieldaccess.PropertyFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class IndexingPropertyFieldAccessorListenerFactory<S extends PropertyContainer, T>
implements FieldAccessorListenerFactory {
    private final PropertyFieldAccessorFactory propertyFieldAccessorFactory;
    private final ConvertingNodePropertyFieldAccessorFactory convertingNodePropertyFieldAccessorFactory;
    private final Neo4jTemplate template;

    public IndexingPropertyFieldAccessorListenerFactory(Neo4jTemplate template, PropertyFieldAccessorFactory propertyFieldAccessorFactory, ConvertingNodePropertyFieldAccessorFactory convertingNodePropertyFieldAccessorFactory) {
        this.template = template;
        this.propertyFieldAccessorFactory = propertyFieldAccessorFactory;
        this.convertingNodePropertyFieldAccessorFactory = convertingNodePropertyFieldAccessorFactory;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        return this.isPropertyField(property) && property.isIndexed();
    }

    private boolean isPropertyField(Neo4jPersistentProperty property) {
        return this.propertyFieldAccessorFactory.accept(property) || this.convertingNodePropertyFieldAccessorFactory.accept(property);
    }

    @Override
    public FieldAccessListener forField(Neo4jPersistentProperty property) {
        return new IndexingPropertyFieldAccessorListener(property, this.template);
    }

    public static class IndexingPropertyFieldAccessorListener<T extends PropertyContainer>
    implements FieldAccessListener {
        private static final Logger log = LoggerFactory.getLogger(IndexingPropertyFieldAccessorListener.class);
        protected final String indexKey;
        private final Neo4jPersistentProperty property;
        private final Neo4jTemplate template;

        public IndexingPropertyFieldAccessorListener(Neo4jPersistentProperty property, Neo4jTemplate template) {
            this.property = property;
            this.template = template;
            this.indexKey = template.getIndexKey(property);
        }

        @Override
        public void valueChanged(Object entity, Object oldVal, Object newVal) {
            Index index = this.template.getIndex(this.property, entity.getClass());
            if (newVal instanceof Number && this.property.getIndexInfo().isNumeric()) {
                newVal = ValueContext.numeric((Number)((Number)newVal));
            }
            Object state = this.template.getPersistentState(entity);
            index.remove(state, this.indexKey);
            if (newVal != null) {
                if (this.property.isUnique()) {
                    this.addUniquely(index, state, newVal);
                } else {
                    index.add(state, this.indexKey, newVal);
                }
            }
        }

        private void addUniquely(Index<T> index, T state, Object newVal) {
            PropertyContainer existingState = index.putIfAbsent(state, this.indexKey, newVal);
            if (existingState == null || existingState.equals(state)) {
                return;
            }
            throw new DataIntegrityViolationException("Unique property " + this.property + " was to be set to duplicate value " + newVal);
        }
    }
}

