/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.conversion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

public class ContainerConverter {
    public static <T, C extends Iterable<T>> C toContainer(Class<C> container, Iterable<T> data) {
        if (Iterable.class.equals(container)) {
            return (C)data;
        }
        if (SortedSet.class.isAssignableFrom(container)) {
            return (C)IteratorUtil.addToCollection(data, new TreeSet());
        }
        if (Set.class.isAssignableFrom(container)) {
            return (C)IteratorUtil.addToCollection(data, new HashSet());
        }
        List list = (List)IteratorUtil.addToCollection(data, new ArrayList(50));
        if (Page.class.isAssignableFrom(container)) {
            return (C)new PageImpl(list);
        }
        return (C)list;
    }
}

