/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import javax.validation.Validator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.TypeRepresentationStrategy;
import org.springframework.data.neo4j.mapping.EntityInstantiator;
import org.springframework.data.neo4j.support.DelegatingGraphDatabase;
import org.springframework.data.neo4j.support.conversion.EntityResultConverter;
import org.springframework.data.neo4j.support.index.IndexProvider;
import org.springframework.data.neo4j.support.index.IndexProviderImpl;
import org.springframework.data.neo4j.support.mapping.EntityRemover;
import org.springframework.data.neo4j.support.mapping.EntityStateHandler;
import org.springframework.data.neo4j.support.mapping.EntityTools;
import org.springframework.data.neo4j.support.mapping.Neo4jEntityPersister;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.node.EntityStateFactory;
import org.springframework.data.neo4j.support.node.NodeEntityInstantiator;
import org.springframework.data.neo4j.support.query.CypherQueryExecutor;
import org.springframework.data.neo4j.support.relationship.RelationshipEntityInstantiator;
import org.springframework.data.neo4j.support.typerepresentation.TypeRepresentationStrategies;
import org.springframework.data.neo4j.support.typerepresentation.TypeRepresentationStrategyFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class MappingInfrastructure {
    private ConversionService conversionService;
    private Validator validator;
    private TypeRepresentationStrategy<Node> nodeTypeRepresentationStrategy;
    private TypeRepresentationStrategy<Relationship> relationshipTypeRepresentationStrategy;
    private TypeRepresentationStrategyFactory typeRepresentationStrategyFactory;
    private Neo4jMappingContext mappingContext;
    private CypherQueryExecutor cypherQueryExecutor;
    private EntityStateHandler entityStateHandler;
    private Neo4jEntityPersister entityPersister;
    private EntityStateFactory<Node> nodeEntityStateFactory;
    private EntityStateFactory<Relationship> relationshipEntityStateFactory;
    private EntityRemover entityRemover;
    private TypeRepresentationStrategies typeRepresentationStrategies;
    private EntityInstantiator<Relationship> relationshipEntityInstantiator;
    private EntityInstantiator<Node> nodeEntityInstantiator;
    private PlatformTransactionManager transactionManager;
    private ResultConverter resultConverter;
    private IndexProvider indexProvider;
    private GraphDatabaseService graphDatabaseService;
    private GraphDatabase graphDatabase;

    public MappingInfrastructure(GraphDatabase graphDatabase, PlatformTransactionManager transactionManager) {
        this.graphDatabase = graphDatabase;
        this.transactionManager = transactionManager;
    }

    public MappingInfrastructure() {
    }

    public void postConstruct() {
        if (this.mappingContext == null) {
            this.mappingContext = new Neo4jMappingContext();
        }
        if (this.graphDatabase == null) {
            this.graphDatabase = new DelegatingGraphDatabase(this.graphDatabaseService);
        }
        if (this.nodeEntityInstantiator == null) {
            this.nodeEntityInstantiator = new NodeEntityInstantiator(this.entityStateHandler);
        }
        if (this.relationshipEntityInstantiator == null) {
            this.relationshipEntityInstantiator = new RelationshipEntityInstantiator(this.entityStateHandler);
        }
        if (this.typeRepresentationStrategyFactory == null) {
            this.typeRepresentationStrategyFactory = new TypeRepresentationStrategyFactory(this.graphDatabase);
        }
        if (this.nodeTypeRepresentationStrategy == null) {
            this.nodeTypeRepresentationStrategy = this.typeRepresentationStrategyFactory.getNodeTypeRepresentationStrategy();
        }
        if (this.relationshipTypeRepresentationStrategy == null) {
            this.relationshipTypeRepresentationStrategy = this.typeRepresentationStrategyFactory.getRelationshipTypeRepresentationStrategy();
        }
        this.typeRepresentationStrategies = new TypeRepresentationStrategies(this.mappingContext, this.nodeTypeRepresentationStrategy, this.relationshipTypeRepresentationStrategy);
        EntityStateHandler entityStateHandler = new EntityStateHandler(this.mappingContext, this.graphDatabase);
        EntityTools<Node> nodeEntityTools = new EntityTools<Node>(this.nodeTypeRepresentationStrategy, this.nodeEntityStateFactory, this.nodeEntityInstantiator);
        EntityTools<Relationship> relationshipEntityTools = new EntityTools<Relationship>(this.relationshipTypeRepresentationStrategy, this.relationshipEntityStateFactory, this.relationshipEntityInstantiator);
        this.entityPersister = new Neo4jEntityPersister(this.conversionService, nodeEntityTools, relationshipEntityTools, this.mappingContext, entityStateHandler);
        this.entityRemover = new EntityRemover(this.entityStateHandler, this.nodeTypeRepresentationStrategy, this.relationshipTypeRepresentationStrategy, this.graphDatabase);
        if (this.resultConverter == null) {
            this.resultConverter = new EntityResultConverter(this.conversionService, this.entityPersister);
        }
        this.graphDatabase.setResultConverter(this.resultConverter);
        this.cypherQueryExecutor = new CypherQueryExecutor(this.graphDatabase.queryEngineFor(QueryType.Cypher, this.resultConverter));
        if (this.indexProvider == null) {
            this.indexProvider = new IndexProviderImpl(this.mappingContext, this.graphDatabase);
        }
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setRelationshipEntityInstantiator(EntityInstantiator<Relationship> relationshipEntityInstantiator) {
        this.relationshipEntityInstantiator = relationshipEntityInstantiator;
    }

    public void setNodeEntityInstantiator(EntityInstantiator<Node> nodeEntityInstantiator) {
        this.nodeEntityInstantiator = nodeEntityInstantiator;
    }

    public void setEntityStateHandler(EntityStateHandler entityStateHandler) {
        this.entityStateHandler = entityStateHandler;
    }

    public void setNodeEntityStateFactory(EntityStateFactory<Node> nodeEntityStateFactory) {
        this.nodeEntityStateFactory = nodeEntityStateFactory;
    }

    public void setRelationshipEntityStateFactory(EntityStateFactory<Relationship> relationshipEntityStateFactory) {
        this.relationshipEntityStateFactory = relationshipEntityStateFactory;
    }

    public EntityStateHandler getEntityStateHandler() {
        return this.entityStateHandler;
    }

    public TypeRepresentationStrategy<Node> getNodeTypeRepresentationStrategy() {
        return this.nodeTypeRepresentationStrategy;
    }

    public void setNodeTypeRepresentationStrategy(TypeRepresentationStrategy<Node> nodeTypeRepresentationStrategy) {
        this.nodeTypeRepresentationStrategy = nodeTypeRepresentationStrategy;
    }

    public TypeRepresentationStrategy<Relationship> getRelationshipTypeRepresentationStrategy() {
        return this.relationshipTypeRepresentationStrategy;
    }

    public void setRelationshipTypeRepresentationStrategy(TypeRepresentationStrategy<Relationship> relationshipTypeRepresentationStrategy) {
        this.relationshipTypeRepresentationStrategy = relationshipTypeRepresentationStrategy;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validatorFactory) {
        this.validator = validatorFactory;
    }

    public void setMappingContext(Neo4jMappingContext mappingContext) {
        this.mappingContext = mappingContext;
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.graphDatabaseService;
    }

    public void setGraphDatabaseService(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    public void setGraphDatabase(GraphDatabase graphDatabase) {
        this.graphDatabase = graphDatabase;
    }

    public GraphDatabase getGraphDatabase() {
        return this.graphDatabase;
    }

    public ResultConverter getResultConverter() {
        return this.resultConverter;
    }

    public EntityRemover getEntityRemover() {
        return this.entityRemover;
    }

    public IndexProvider getIndexProvider() {
        return this.indexProvider;
    }

    public Neo4jEntityPersister getEntityPersister() {
        return this.entityPersister;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public TypeRepresentationStrategies getTypeRepresentationStrategies() {
        return this.typeRepresentationStrategies;
    }

    public CypherQueryExecutor getCypherQueryExecutor() {
        return this.cypherQueryExecutor;
    }

    public Neo4jMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public void setTypeRepresentationStrategyFactory(TypeRepresentationStrategyFactory typeRepresentationStrategyFactory) {
        this.typeRepresentationStrategyFactory = typeRepresentationStrategyFactory;
    }

    public void setIndexProvider(IndexProvider indexProvider) {
        this.indexProvider = indexProvider;
    }
}

