/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.ClosableIterable;
import org.springframework.data.neo4j.core.TypeRepresentationStrategy;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;

public class TypeRepresentationStrategies
implements TypeRepresentationStrategy<PropertyContainer> {
    private final Neo4jMappingContext mappingContext;
    private final TypeRepresentationStrategy<Node> nodeTypeRepresentationStrategy;
    private final TypeRepresentationStrategy<Relationship> relationshipTypeRepresentationStrategy;

    public TypeRepresentationStrategies(Neo4jMappingContext mappingContext, TypeRepresentationStrategy<Node> nodeTypeRepresentationStrategy, TypeRepresentationStrategy<Relationship> relationshipTypeRepresentationStrategy) {
        this.mappingContext = mappingContext;
        this.nodeTypeRepresentationStrategy = nodeTypeRepresentationStrategy;
        this.relationshipTypeRepresentationStrategy = relationshipTypeRepresentationStrategy;
    }

    private <T> TypeRepresentationStrategy<?> getTypeRepresentationStrategy(Class<T> type) {
        if (this.mappingContext.isNodeEntity(type)) {
            return this.nodeTypeRepresentationStrategy;
        }
        if (this.mappingContext.isRelationshipEntity(type)) {
            return this.relationshipTypeRepresentationStrategy;
        }
        throw new IllegalArgumentException("Type is not @NodeEntity nor @RelationshipEntity.");
    }

    private <S extends PropertyContainer, T> TypeRepresentationStrategy<S> getTypeRepresentationStrategy(S state, Class<T> type) {
        if (state instanceof Node && this.mappingContext.isNodeEntity(type)) {
            return this.nodeTypeRepresentationStrategy;
        }
        if (state instanceof Relationship && this.mappingContext.isRelationshipEntity(type)) {
            return this.relationshipTypeRepresentationStrategy;
        }
        throw new IllegalArgumentException("Type is not @NodeEntity nor @RelationshipEntity.");
    }

    private <S extends PropertyContainer, T> TypeRepresentationStrategy<S> getTypeRepresentationStrategy(S state) {
        if (state instanceof Node) {
            return this.nodeTypeRepresentationStrategy;
        }
        if (state instanceof Relationship) {
            return this.relationshipTypeRepresentationStrategy;
        }
        throw new IllegalArgumentException("Type is not @NodeEntity nor @RelationshipEntity.");
    }

    @Override
    public void postEntityCreation(PropertyContainer state, Class<?> type) {
        this.getTypeRepresentationStrategy(state, type).postEntityCreation(state, type);
    }

    @Override
    public <U> ClosableIterable<PropertyContainer> findAll(Class<U> type) {
        return this.getTypeRepresentationStrategy((PropertyContainer)type).findAll(type);
    }

    @Override
    public long count(Class<?> type) {
        return this.getTypeRepresentationStrategy((PropertyContainer)type).count(type);
    }

    @Override
    public <U> Class<U> getJavaType(PropertyContainer state) {
        return this.getTypeRepresentationStrategy(state).getJavaType(state);
    }

    @Override
    public void preEntityRemoval(PropertyContainer state) {
        this.getTypeRepresentationStrategy(state).preEntityRemoval(state);
    }

    public TypeRepresentationStrategy<Node> getNodeTypeRepresentationStrategy() {
        return this.nodeTypeRepresentationStrategy;
    }

    public TypeRepresentationStrategy<Relationship> getRelationshipTypeRepresentationStrategy() {
        return this.relationshipTypeRepresentationStrategy;
    }
}

