/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.node;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexManager;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public abstract class Neo4jHelper {
    public static void cleanDb(Neo4jTemplate template) {
        Neo4jHelper.cleanDb(template.getGraphDatabaseService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanDb(GraphDatabaseService graphDatabaseService) {
        Transaction tx = graphDatabaseService.beginTx();
        try {
            Neo4jHelper.removeNodes(graphDatabaseService);
            Neo4jHelper.clearIndex(graphDatabaseService);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private static void removeNodes(GraphDatabaseService graphDatabaseService) {
        Node refNode = graphDatabaseService.getReferenceNode();
        for (Node node : graphDatabaseService.getAllNodes()) {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                rel.delete();
            }
        }
        for (Node node : graphDatabaseService.getAllNodes()) {
            if (refNode.equals(node)) continue;
            node.delete();
        }
    }

    private static void clearIndex(GraphDatabaseService gds) {
        IndexManager indexManager = gds.index();
        for (String ix : indexManager.nodeIndexNames()) {
            indexManager.forNodes(ix).delete();
        }
        for (String ix : indexManager.relationshipIndexNames()) {
            indexManager.forRelationships(ix).delete();
        }
    }
}

