/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.CypherQueryDefinition;
import org.springframework.data.neo4j.repository.query.MatchClause;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.StartClause;
import org.springframework.data.neo4j.repository.query.VariableContext;
import org.springframework.data.neo4j.repository.query.WhereClause;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class CypherQueryBuilder
implements CypherQueryDefinition {
    private final MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty> context;
    private final VariableContext variableContext = new VariableContext();
    private final List<MatchClause> matchClauses = new ArrayList<MatchClause>();
    private final List<StartClause> startClauses = new ArrayList<StartClause>();
    private final List<WhereClause> whereClauses = new ArrayList<WhereClause>();
    private int index = 0;
    private final Neo4jPersistentEntity<?> entity;

    public CypherQueryBuilder(MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty> context, Class<?> type) {
        Assert.notNull(context);
        Assert.notNull(type);
        this.context = context;
        this.entity = (Neo4jPersistentEntity)context.getPersistentEntity(type);
    }

    private String defaultStartClause() {
        return String.format("%s=node:__types__(className=\"%s\")", this.variableContext.getVariableFor(this.entity), this.entity.getType().getName());
    }

    public CypherQueryBuilder addRestriction(Part part) {
        String variable;
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        PartInfo partInfo = new PartInfo((PersistentPropertyPath<Neo4jPersistentProperty>)path, variable = this.variableContext.getVariableFor((PersistentPropertyPath<Neo4jPersistentProperty>)path), part, this.index);
        if (partInfo.isPrimitiveProperty()) {
            if (partInfo.isIndexed()) {
                this.startClauses.add(new StartClause(partInfo));
            } else {
                this.whereClauses.add(new WhereClause((PersistentPropertyPath<Neo4jPersistentProperty>)path, variable, part.getType(), this.index, partInfo));
            }
        }
        ++this.index;
        MatchClause matchClause = new MatchClause((PersistentPropertyPath<Neo4jPersistentProperty>)path);
        if (matchClause.hasRelationship()) {
            this.matchClauses.add(matchClause);
        }
        return this;
    }

    @Override
    public PartInfo getPartInfo(int parameterIndex) {
        for (StartClause startClause : this.startClauses) {
            if (startClause.getPartInfo().getParameterIndex() != parameterIndex) continue;
            return startClause.getPartInfo();
        }
        for (WhereClause whereClause : this.whereClauses) {
            if (whereClause.getPartInfo().getParameterIndex() != parameterIndex) continue;
            return whereClause.getPartInfo();
        }
        throw new IllegalArgumentException("Index " + parameterIndex + " not valid");
    }

    @Override
    public String toString() {
        String startClauses = StringUtils.collectionToDelimitedString(this.startClauses, (String)", ");
        String matchClauses = this.toString(this.matchClauses);
        String whereClauses = StringUtils.collectionToDelimitedString(this.whereClauses, (String)" and ");
        StringBuilder builder = new StringBuilder("start ");
        if (StringUtils.hasText((String)startClauses)) {
            builder.append(startClauses);
        } else {
            builder.append(this.defaultStartClause());
        }
        if (StringUtils.hasText((String)matchClauses)) {
            builder.append(" match ").append(matchClauses);
        }
        if (StringUtils.hasText((String)whereClauses)) {
            builder.append(" where ").append(whereClauses);
        }
        builder.append(" return ").append(this.variableContext.getVariableFor(this.entity));
        return builder.toString();
    }

    @Override
    public String toString(Pageable pageable) {
        StringBuilder builder = new StringBuilder(this.toString(pageable.getSort()));
        if (pageable != null) {
            builder.append(String.format(" skip %d limit %d", pageable.getOffset(), pageable.getPageSize()));
        }
        return builder.toString();
    }

    @Override
    public String toString(Sort sort) {
        StringBuilder builder = new StringBuilder(this.toString());
        builder.append(this.addSorts(sort));
        return builder.toString();
    }

    private String addSorts(Sort sort) {
        List<String> sorts = this.formatSorts(sort);
        return !sorts.isEmpty() ? String.format(" order by %s", StringUtils.collectionToCommaDelimitedString(sorts)) : "";
    }

    private List<String> formatSorts(Sort sort) {
        ArrayList<String> result = new ArrayList<String>();
        if (sort == null) {
            return result;
        }
        for (Sort.Order order : sort) {
            result.add(String.format("%s %s", order.getProperty(), order.getDirection()));
        }
        return result;
    }

    private String toString(List<MatchClause> matchClauses) {
        ArrayList<String> result = new ArrayList<String>(matchClauses.size());
        for (MatchClause matchClause : matchClauses) {
            result.add(matchClause.toString(this.variableContext));
        }
        return StringUtils.collectionToDelimitedString(result, (String)", ");
    }
}

