/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import org.neo4j.graphdb.PropertyContainer;
import org.springframework.data.neo4j.repository.CRUDRepository;
import org.springframework.data.neo4j.repository.GraphRepositoryFactory;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;
import org.springframework.util.Assert;

public class GraphRepositoryFactoryBean<S extends PropertyContainer, R extends CRUDRepository<T>, T>
extends TransactionalRepositoryFactoryBeanSupport<R, T, Long> {
    private Neo4jTemplate template;
    private Neo4jMappingContext mappingContext;

    public void setNeo4jTemplate(Neo4jTemplate template) {
        this.template = template;
    }

    public void setMappingContext(Neo4jMappingContext mappingContext) {
        this.mappingContext = mappingContext;
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        return this.createRepositoryFactory(this.template);
    }

    protected RepositoryFactorySupport createRepositoryFactory(Neo4jTemplate template) {
        return new GraphRepositoryFactory(template, this.mappingContext);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.template, (String)"Neo4jTemplate must not be null!");
        if (this.mappingContext == null) {
            Neo4jMappingContext context = new Neo4jMappingContext();
            context.afterPropertiesSet();
            this.mappingContext = context;
        }
        super.afterPropertiesSet();
    }
}

