/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.relationship;

import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.neo4j.core.RelationshipBacked;
import org.springframework.data.neo4j.fieldaccess.DefaultEntityState;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.support.GraphDatabaseContext;
import org.springframework.data.neo4j.support.relationship.Neo4jRelationshipBacking;

public class RelationshipEntityState<ENTITY extends RelationshipBacked>
extends DefaultEntityState<ENTITY, Relationship> {
    private final GraphDatabaseContext graphDatabaseContext;

    public RelationshipEntityState(Relationship underlyingState, ENTITY entity, Class<? extends ENTITY> type, GraphDatabaseContext graphDatabaseContext, DelegatingFieldAccessorFactory<RelationshipBacked> delegatingFieldAccessorFactory) {
        super(underlyingState, entity, type, delegatingFieldAccessorFactory);
        this.graphDatabaseContext = graphDatabaseContext;
    }

    @Override
    public void createAndAssignState() {
        if (Neo4jRelationshipBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_core_RelationshipBacked$getPersistentState((RelationshipBacked)this.entity) != null) {
            return;
        }
        try {
            Object id = this.getIdFromEntity();
            if (id instanceof Number) {
                Relationship relationship = this.graphDatabaseContext.getRelationshipById(((Number)id).longValue());
                this.setPersistentState(relationship);
                if (DefaultEntityState.log.isInfoEnabled()) {
                    DefaultEntityState.log.info((Object)("Entity reattached " + ((RelationshipBacked)this.entity).getClass() + "; used Relationship [" + Neo4jRelationshipBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_core_RelationshipBacked$getPersistentState((RelationshipBacked)this.entity) + "];"));
                }
                return;
            }
            Object relationship = null;
            this.setPersistentState(relationship);
            if (DefaultEntityState.log.isInfoEnabled()) {
                DefaultEntityState.log.info((Object)("User-defined constructor called on class " + ((RelationshipBacked)this.entity).getClass() + "; created Relationship [" + this.getPersistentState() + "]; Updating metamodel"));
            }
        }
        catch (NotInTransactionException e) {
            throw new InvalidDataAccessResourceUsageException("Not in a Neo4j transaction.", (Throwable)e);
        }
    }

    @Override
    public ENTITY persist() {
        this.createAndAssignState();
        return (ENTITY)((RelationshipBacked)this.entity);
    }
}

