/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.query;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.conversion.QueryResult;
import org.springframework.data.neo4j.conversion.QueryResultBuilder;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.support.query.GremlinExecutor;
import org.springframework.data.neo4j.support.query.QueryEngine;

public class GremlinQueryEngine
implements QueryEngine<Object> {
    private final GremlinExecutor gremlinExecutor;
    private final ResultConverter resultConverter;

    public GremlinQueryEngine(GraphDatabaseService graphDatabaseService) {
        this(graphDatabaseService, new DefaultConverter());
    }

    public GremlinQueryEngine(GraphDatabaseService graphDatabaseService, ResultConverter resultConverter) {
        this.resultConverter = resultConverter != null ? resultConverter : new DefaultConverter();
        this.gremlinExecutor = new GremlinExecutor(graphDatabaseService);
    }

    @Override
    public QueryResult<Object> query(String statement, Map<String, Object> params) {
        try {
            Iterable<Object> result = this.gremlinExecutor.query(statement, params);
            return new QueryResultBuilder<Object>(result, this.resultConverter);
        }
        catch (Exception e) {
            throw new InvalidDataAccessResourceUsageException("Error executing statement " + statement, (Throwable)e);
        }
    }
}

