/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.data.domain.Page;

public class GenericTypeExtractor {
    public static Class<?> resolveReturnedType(Method method) {
        return GenericTypeExtractor.resolveConcreteType(method.getReturnType(), method.getGenericReturnType());
    }

    public static Class<?> resolveFieldType(Field field) {
        return GenericTypeExtractor.resolveConcreteType(field.getType(), field.getGenericType());
    }

    public static Class<?> resolveConcreteType(Class<?> type, Type genericType) {
        if (Iterable.class.isAssignableFrom(type) || Page.class.isAssignableFrom(type)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType returnType = (ParameterizedType)genericType;
                Type componentType = returnType.getActualTypeArguments()[0];
                return componentType instanceof ParameterizedType ? (Class)((ParameterizedType)componentType).getRawType() : (Class)componentType;
            }
            return Object.class;
        }
        return type;
    }
}

