/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.NodeRelationshipFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.NodeToNodesRelationshipFieldAccessor;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.GraphDatabaseContext;

public class SingleRelationshipFieldAccessorFactory
extends NodeRelationshipFieldAccessorFactory {
    public SingleRelationshipFieldAccessorFactory(GraphDatabaseContext graphDatabaseContext) {
        super(graphDatabaseContext);
    }

    @Override
    public boolean accept(Field f) {
        return NodeBacked.class.isAssignableFrom(f.getType());
    }

    @Override
    public FieldAccessor<NodeBacked> forField(Field field) {
        RelatedTo relAnnotation = this.getRelationshipAnnotation(field);
        if (relAnnotation == null) {
            return new SingleRelationshipFieldAccessor((RelationshipType)this.typeFrom(field), Direction.OUTGOING, this.targetFrom(field, relAnnotation), this.graphDatabaseContext, field);
        }
        return new SingleRelationshipFieldAccessor((RelationshipType)this.typeFrom(field, relAnnotation), this.dirFrom(relAnnotation), this.targetFrom(field, relAnnotation), this.graphDatabaseContext, field);
    }

    public static class SingleRelationshipFieldAccessor
    extends NodeToNodesRelationshipFieldAccessor<NodeBacked> {
        public SingleRelationshipFieldAccessor(RelationshipType type, Direction direction, Class<? extends NodeBacked> clazz, GraphDatabaseContext graphDatabaseContext, Field field) {
            super(clazz, graphDatabaseContext, direction, type, field);
        }

        @Override
        public Object setValue(NodeBacked entity, Object newVal) {
            Node node = (Node)this.checkUnderlyingNode(entity);
            if (newVal == null) {
                this.removeMissingRelationships(node, Collections.<Node>emptySet());
                return null;
            }
            Set<Node> target = this.checkTargetIsSetOfNodebacked(Collections.singleton(newVal));
            this.removeMissingRelationships(node, target);
            this.createAddedRelationships(node, target);
            return newVal;
        }

        @Override
        public Object getValue(NodeBacked entity) {
            this.checkUnderlyingNode(entity);
            Set result = this.createEntitySetFromRelationshipEndNodes(entity);
            NodeBacked singleEntity = result.isEmpty() ? null : (NodeBacked)result.iterator().next();
            return DoReturn.doReturn(singleEntity);
        }
    }
}

