/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import org.neo4j.graphdb.PropertyContainer;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.core.GraphBacked;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.support.DoReturn;

public class PropertyFieldAccessorFactory
implements FieldAccessorFactory<GraphBacked<PropertyContainer>> {
    private final ConversionService conversionService;

    public PropertyFieldAccessorFactory(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean accept(Field f) {
        return this.isNeo4jPropertyType(f.getType());
    }

    @Override
    public FieldAccessor<GraphBacked<PropertyContainer>> forField(Field field) {
        return new PropertyFieldAccessor(this.conversionService, DelegatingFieldAccessorFactory.getNeo4jPropertyName(field), field.getType());
    }

    private boolean isNeo4jPropertyType(Class<?> fieldType) {
        return fieldType.isPrimitive() || fieldType.equals(String.class) || fieldType.equals(Character.class) || fieldType.equals(Boolean.class) || fieldType.getName().startsWith("java.lang") && Number.class.isAssignableFrom(fieldType) || fieldType.isArray() && !fieldType.getComponentType().isArray() && this.isNeo4jPropertyType(fieldType.getComponentType());
    }

    public static class PropertyFieldAccessor
    implements FieldAccessor<GraphBacked<PropertyContainer>> {
        private final ConversionService conversionService;
        protected final String propertyName;
        protected final Class<?> fieldType;

        public PropertyFieldAccessor(ConversionService conversionService, String propertyName, Class fieldType) {
            this.conversionService = conversionService;
            this.propertyName = propertyName;
            this.fieldType = fieldType;
        }

        @Override
        public boolean isWriteable(GraphBacked<PropertyContainer> graphBacked) {
            return true;
        }

        @Override
        public Object setValue(GraphBacked<PropertyContainer> graphBacked, Object newVal) {
            PropertyContainer propertyContainer = graphBacked.getPersistentState();
            if (newVal == null) {
                propertyContainer.removeProperty(this.propertyName);
            } else {
                propertyContainer.setProperty(this.propertyName, newVal);
            }
            return newVal;
        }

        @Override
        public final Object getValue(GraphBacked<PropertyContainer> graphBacked) {
            return DoReturn.doReturn(this.doGetValue(graphBacked));
        }

        protected Object doGetValue(GraphBacked<PropertyContainer> graphBacked) {
            PropertyContainer element = graphBacked.getPersistentState();
            if (element.hasProperty(this.propertyName)) {
                Object value = element.getProperty(this.propertyName);
                if (value == null || this.fieldType.isInstance(value)) {
                    return value;
                }
                if (this.conversionService != null) {
                    return this.conversionService.convert(value, this.fieldType);
                }
                return value;
            }
            return this.getDefaultValue(this.fieldType);
        }

        private Object getDefaultValue(Class<?> type) {
            if (type.isPrimitive()) {
                if (type.equals(Boolean.TYPE)) {
                    return false;
                }
                return 0;
            }
            return null;
        }
    }
}

