/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.transaction;

import javax.naming.NamingException;
import javax.transaction.SystemException;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.Jotm;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class JotmFactoryBean
implements FactoryBean,
DisposableBean,
InitializingBean {
    private Current jotmCurrent;
    private Jotm jotm;
    private String jotmHome;
    private Integer defaultTimeout;
    private Boolean transactionRecovery;

    public void setDefaultTimeout(int defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public void setTransactionRecovery(boolean transactionRecovery) throws SystemException {
        this.transactionRecovery = transactionRecovery;
    }

    public void setJotmHome(String jotmHome) {
        this.jotmHome = jotmHome;
    }

    public void afterPropertiesSet() throws Exception {
        this.createJotm();
    }

    private void createJotm() throws NamingException, SystemException {
        if (this.jotmHome != null) {
            System.setProperty("jotm.home", this.jotmHome);
        }
        this.jotmCurrent = Current.getCurrent();
        if (this.jotmCurrent == null) {
            this.jotm = new Jotm(true, false);
            this.jotmCurrent = Current.getCurrent();
        }
        if (this.defaultTimeout != null) {
            this.jotmCurrent.setDefaultTimeout(this.defaultTimeout.intValue());
        }
        if (this.transactionRecovery != null) {
            this.jotmCurrent.setTransactionRecovery(this.transactionRecovery.booleanValue());
        }
    }

    public Jotm getJotm() {
        return this.jotm;
    }

    public Object getObject() {
        return this.jotmCurrent;
    }

    public Class getObjectType() {
        return this.jotmCurrent.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.jotm != null) {
            this.jotm.stop();
        }
    }
}

