/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.template;

import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.graph.UncategorizedGraphStoreException;
import org.springframework.data.graph.core.GraphDatabase;
import org.springframework.data.graph.core.Property;
import org.springframework.data.graph.neo4j.support.path.NodePath;
import org.springframework.data.graph.neo4j.support.path.PathMapper;
import org.springframework.data.graph.neo4j.support.path.PathMappingIterator;
import org.springframework.data.graph.neo4j.support.path.RelationshipPath;
import org.springframework.data.graph.neo4j.template.GraphCallback;
import org.springframework.data.graph.neo4j.template.Neo4jExceptionTranslator;
import org.springframework.data.graph.neo4j.template.Neo4jOperations;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class Neo4jTemplate
implements Neo4jOperations {
    private final GraphDatabase graphDatabase;
    private final PlatformTransactionManager transactionManager;
    private final Neo4jExceptionTranslator exceptionTranslator = new Neo4jExceptionTranslator();

    private static void notNull(Object ... pairs) {
        assert (pairs.length % 2 == 0) : "wrong number of pairs to check";
        int i = 0;
        while (i < pairs.length) {
            if (pairs[i] == null) {
                throw new InvalidDataAccessApiUsageException("[Assertion failed] - " + pairs[i + 1] + " is required; it must not be null");
            }
            i += 2;
        }
    }

    public Neo4jTemplate(GraphDatabase graphDatabase, PlatformTransactionManager transactionManager) {
        Neo4jTemplate.notNull(graphDatabase, "graphDatabase");
        this.transactionManager = transactionManager;
        this.graphDatabase = graphDatabase;
    }

    public Neo4jTemplate(GraphDatabase graphDatabase) {
        Neo4jTemplate.notNull(graphDatabase, "graphDatabase");
        this.transactionManager = null;
        this.graphDatabase = graphDatabase;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    private <T> T doExecute(GraphCallback<T> callback) {
        Neo4jTemplate.notNull(callback, "callback");
        try {
            return callback.doWithGraph(this.graphDatabase);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
        catch (Exception e) {
            throw new UncategorizedGraphStoreException("Error executing callback", (Throwable)e);
        }
    }

    @Override
    public <T> T exec(final GraphCallback<T> callback) {
        if (this.transactionManager == null) {
            return this.doExecute(callback);
        }
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        return (T)template.execute(new TransactionCallback<T>(){

            public T doInTransaction(TransactionStatus status) {
                return Neo4jTemplate.this.doExecute(callback);
            }
        });
    }

    @Override
    public Node getReferenceNode() {
        try {
            return this.graphDatabase.getReferenceNode();
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public Node createNode(final Property ... properties) {
        return this.exec(new GraphCallback<Node>(){

            @Override
            public Node doWithGraph(GraphDatabase graph) throws Exception {
                return Neo4jTemplate.this.graphDatabase.createNode(properties);
            }
        });
    }

    @Override
    public Node getNode(long id) {
        if (id < 0L) {
            throw new InvalidDataAccessApiUsageException("id is negative");
        }
        try {
            return this.graphDatabase.getNodeById(id);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public Relationship getRelationship(long id) {
        if (id < 0L) {
            throw new InvalidDataAccessApiUsageException("id is negative");
        }
        try {
            return this.graphDatabase.getRelationshipById(id);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T extends PropertyContainer> T index(final String indexName, final T element, final String field, final Object value) {
        Neo4jTemplate.notNull(element, "element", field, "field", value, "value", indexName, "indexName");
        this.exec(new GraphCallback.WithoutResult(){

            @Override
            public void doWithGraphWithoutResult(GraphDatabase graph) throws Exception {
                if (element instanceof Relationship) {
                    Index<Relationship> relationshipIndex = Neo4jTemplate.this.graphDatabase.createIndex(Relationship.class, indexName, false);
                    relationshipIndex.add((PropertyContainer)((Relationship)element), field, value);
                } else if (element instanceof Node) {
                    Neo4jTemplate.this.graphDatabase.createIndex(Node.class, indexName, false).add((PropertyContainer)((Node)element), field, value);
                } else {
                    throw new IllegalArgumentException("Provided element is neither node nor relationship " + element);
                }
            }
        });
        return element;
    }

    @Override
    public <T> ClosableIterable<T> query(String indexName, PathMapper<T> pathMapper, Object queryOrQueryObject) {
        Neo4jTemplate.notNull(queryOrQueryObject, "queryOrQueryObject", pathMapper, "pathMapper", indexName, "indexName");
        try {
            Index index = this.graphDatabase.getIndex(indexName);
            if (Relationship.class.isAssignableFrom(index.getEntityType())) {
                return this.mapRelationships((IndexHits<Relationship>)index.query(queryOrQueryObject), pathMapper);
            }
            return this.mapNodes((IndexHits<Node>)index.query(queryOrQueryObject), pathMapper);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> ClosableIterable<T> query(String indexName, PathMapper<T> pathMapper, String field, String value) {
        Neo4jTemplate.notNull(field, "field", value, "value", pathMapper, "pathMapper", indexName, "indexName");
        try {
            Index index = this.graphDatabase.getIndex(indexName);
            if (Relationship.class.isAssignableFrom(index.getEntityType())) {
                return this.mapRelationships((IndexHits<Relationship>)index.get(field, (Object)value), pathMapper);
            }
            return this.mapNodes((IndexHits<Node>)index.get(field, (Object)value), pathMapper);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    private <T> ClosableIterable<T> mapNodes(IndexHits<Node> nodes, PathMapper<T> pathMapper) {
        assert (nodes != null);
        assert (pathMapper != null);
        return new IndexHitsIterableWrapper<T, Node>(nodes, pathMapper){

            @Override
            protected Path createPath(Node node) {
                return new NodePath(node);
            }
        };
    }

    private <T> ClosableIterable<T> mapRelationships(IndexHits<Relationship> relationships, PathMapper<T> pathMapper) {
        assert (relationships != null);
        assert (pathMapper != null);
        return new IndexHitsIterableWrapper<T, Relationship>(relationships, pathMapper){

            @Override
            protected Path createPath(Relationship relationship) {
                return new RelationshipPath(relationship);
            }
        };
    }

    @Override
    public <T> Iterable<T> traverseGraph(Node startNode, PathMapper<T> pathMapper, TraversalDescription traversal) {
        Neo4jTemplate.notNull(startNode, "startNode", traversal, "traversal", pathMapper, "pathMapper");
        try {
            return this.mapPaths((Iterable<Path>)traversal.traverse(startNode), pathMapper);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    private <T> Iterable<T> mapPaths(Iterable<Path> paths, PathMapper<T> pathMapper) {
        return new PathMappingIterator().mapPaths(paths, pathMapper);
    }

    @Override
    public <T> Iterable<T> traverseNext(Node startNode, PathMapper<T> pathMapper, RelationshipType relationshipType, Direction direction) {
        Neo4jTemplate.notNull(startNode, "startNode", relationshipType, "relationshipType", direction, "direction", pathMapper, "pathMapper");
        try {
            return this.mapRelationships(startNode.getRelationships(relationshipType, direction), pathMapper);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> Iterable<T> traverseNext(Node startNode, PathMapper<T> pathMapper, RelationshipType ... relationshipTypes) {
        Neo4jTemplate.notNull(startNode, "startNode", relationshipTypes, "relationshipType", pathMapper, "pathMapper");
        try {
            return this.mapRelationships(startNode.getRelationships(relationshipTypes), pathMapper);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    @Override
    public <T> Iterable<T> traverseNext(Node startNode, PathMapper<T> pathMapper) {
        Neo4jTemplate.notNull(startNode, "startNode", pathMapper, "pathMapper");
        try {
            return this.mapRelationships(startNode.getRelationships(), pathMapper);
        }
        catch (RuntimeException e) {
            throw this.translateExceptionIfPossible(e);
        }
    }

    private <T> Iterable<T> mapRelationships(Iterable<Relationship> relationships, final PathMapper<T> pathMapper) {
        assert (relationships != null);
        assert (pathMapper != null);
        return new IterableWrapper<T, Relationship>(relationships){

            protected T underlyingObjectToObject(Relationship relationship) {
                return pathMapper.mapPath(new RelationshipPath(relationship));
            }
        };
    }

    @Override
    public Relationship createRelationship(final Node startNode, final Node endNode, final RelationshipType relationshipType, final Property ... properties) {
        Neo4jTemplate.notNull(startNode, "startNode", endNode, "endNode", relationshipType, "relationshipType", properties, "properties");
        return this.exec(new GraphCallback<Relationship>(){

            @Override
            public Relationship doWithGraph(GraphDatabase graph) throws Exception {
                return graph.createRelationship(startNode, endNode, relationshipType, properties);
            }
        });
    }

    private <T extends PropertyContainer> T setProperties(T primitive, Map<String, Object> properties) {
        assert (primitive != null);
        if (properties == null) {
            return primitive;
        }
        for (Map.Entry<String, Object> prop : properties.entrySet()) {
            if (prop.getValue() == null) {
                primitive.removeProperty(prop.getKey());
                continue;
            }
            primitive.setProperty(prop.getKey(), prop.getValue());
        }
        return primitive;
    }

    private static abstract class IndexHitsIterableWrapper<T, S extends PropertyContainer>
    extends IterableWrapper<T, S>
    implements ClosableIterable<T> {
        private final IndexHits<S> indexHits;
        private final PathMapper<T> pathMapper;

        public IndexHitsIterableWrapper(IndexHits<S> indexHits, PathMapper<T> pathMapper) {
            super(indexHits);
            this.indexHits = indexHits;
            this.pathMapper = pathMapper;
        }

        protected T underlyingObjectToObject(S node) {
            return this.pathMapper.mapPath(this.createPath(node));
        }

        protected abstract Path createPath(S var1);

        public void close() {
            this.indexHits.close();
        }
    }
}

