/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.support.node;

import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnitUtil;
import org.neo4j.graphdb.Node;
import org.springframework.data.graph.annotation.NodeEntity;
import org.springframework.data.graph.core.EntityState;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.neo4j.fieldaccess.DetachedEntityState;
import org.springframework.data.graph.neo4j.fieldaccess.NodeDelegatingFieldAccessorFactory;
import org.springframework.data.graph.neo4j.support.GraphDatabaseContext;
import org.springframework.data.graph.neo4j.support.node.NodeEntityState;
import org.springframework.data.graph.neo4j.support.node.PartialNodeEntityState;
import org.springframework.orm.jpa.aspectj.JpaExceptionTranslatorAspect;

public class NodeEntityStateFactory {
    private GraphDatabaseContext graphDatabaseContext;
    private EntityManagerFactory entityManagerFactory;
    private NodeDelegatingFieldAccessorFactory nodeDelegatingFieldAccessorFactory;
    private PartialNodeEntityState.PartialNodeDelegatingFieldAccessorFactory delegatingFieldAccessorFactory;

    public EntityState<NodeBacked, Node> getEntityState(final NodeBacked entity) {
        NodeEntity graphEntityAnnotation = entity.getClass().getAnnotation(NodeEntity.class);
        if (graphEntityAnnotation.partial()) {
            final PartialNodeEntityState<NodeBacked> partialNodeEntityState = new PartialNodeEntityState<NodeBacked>(null, entity, entity.getClass(), this.graphDatabaseContext, this.getPersistenceUnitUtils(), this.delegatingFieldAccessorFactory);
            return new DetachedEntityState<NodeBacked, Node>(partialNodeEntityState, this.graphDatabaseContext){

                @Override
                protected boolean isDetached() {
                    return super.isDetached() || partialNodeEntityState.getId(entity) == null;
                }
            };
        }
        NodeEntityState<NodeBacked> nodeEntityState = new NodeEntityState<NodeBacked>(null, entity, entity.getClass(), this.graphDatabaseContext, this.nodeDelegatingFieldAccessorFactory);
        return new DetachedEntityState<NodeBacked, Node>(nodeEntityState, this.graphDatabaseContext);
    }

    private PersistenceUnitUtil getPersistenceUnitUtils() {
        PersistenceUnitUtil persistenceUnitUtil;
        if (this.entityManagerFactory == null) {
            return null;
        }
        try {
            persistenceUnitUtil = this.entityManagerFactory.getPersistenceUnitUtil();
        }
        catch (RuntimeException runtimeException) {
            JpaExceptionTranslatorAspect.aspectOf().ajc$afterThrowing$org_springframework_orm_jpa_aspectj_JpaExceptionTranslatorAspect$1$18a1ac9(runtimeException);
            throw runtimeException;
        }
        return persistenceUnitUtil;
    }

    public void setNodeDelegatingFieldAccessorFactory(NodeDelegatingFieldAccessorFactory nodeDelegatingFieldAccessorFactory) {
        this.nodeDelegatingFieldAccessorFactory = nodeDelegatingFieldAccessorFactory;
    }

    public void setGraphDatabaseContext(GraphDatabaseContext graphDatabaseContext) {
        this.graphDatabaseContext = graphDatabaseContext;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @PostConstruct
    private void setUp() {
        this.delegatingFieldAccessorFactory = new PartialNodeEntityState.PartialNodeDelegatingFieldAccessorFactory(this.graphDatabaseContext);
    }
}

