/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.fieldaccess;

import java.lang.reflect.Field;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.graph.annotation.EndNode;
import org.springframework.data.graph.annotation.StartNode;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.core.RelationshipBacked;
import org.springframework.data.graph.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.graph.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.graph.neo4j.support.DoReturn;
import org.springframework.data.graph.neo4j.support.GraphDatabaseContext;
import org.springframework.data.graph.neo4j.support.relationship.Neo4jRelationshipBacking;

public class RelationshipNodeFieldAccessorFactory
implements FieldAccessorFactory<RelationshipBacked> {
    private GraphDatabaseContext graphDatabaseContext;

    public RelationshipNodeFieldAccessorFactory(GraphDatabaseContext graphDatabaseContext) {
        this.graphDatabaseContext = graphDatabaseContext;
    }

    @Override
    public boolean accept(Field f) {
        return this.isStartNodeField(f) || this.isEndNodeField(f);
    }

    private boolean isEndNodeField(Field f) {
        return f.isAnnotationPresent(EndNode.class);
    }

    private boolean isStartNodeField(Field f) {
        return f.isAnnotationPresent(StartNode.class);
    }

    @Override
    public FieldAccessor<RelationshipBacked> forField(Field f) {
        if (this.isStartNodeField(f)) {
            return new RelationshipNodeFieldAccessor(f, this.graphDatabaseContext){

                @Override
                protected Node getNode(Relationship relationship) {
                    return relationship.getStartNode();
                }
            };
        }
        if (this.isEndNodeField(f)) {
            return new RelationshipNodeFieldAccessor(f, this.graphDatabaseContext){

                @Override
                protected Node getNode(Relationship relationship) {
                    return relationship.getEndNode();
                }
            };
        }
        return null;
    }

    public static abstract class RelationshipNodeFieldAccessor
    implements FieldAccessor<RelationshipBacked> {
        private final Field field;
        private final GraphDatabaseContext graphDatabaseContext;

        public RelationshipNodeFieldAccessor(Field field, GraphDatabaseContext graphDatabaseContext) {
            this.field = field;
            this.graphDatabaseContext = graphDatabaseContext;
        }

        @Override
        public Object setValue(RelationshipBacked relationshipBacked, Object newVal) {
            throw new InvalidDataAccessApiUsageException("Cannot change start or end node of existing relationship.");
        }

        @Override
        public Object getValue(RelationshipBacked relationshipBacked) {
            Relationship relationship = Neo4jRelationshipBacking.ajc$interMethodDispatch1$org_springframework_data_graph_neo4j_support_relationship_Neo4jRelationshipBacking$org_springframework_data_graph_core_RelationshipBacked$getPersistentState(relationshipBacked);
            Node node = this.getNode(relationship);
            if (node == null) {
                return null;
            }
            NodeBacked result = (NodeBacked)this.graphDatabaseContext.createEntityFromState(node, this.field.getType());
            return DoReturn.doReturn(result);
        }

        protected abstract Node getNode(Relationship var1);

        @Override
        public boolean isWriteable(RelationshipBacked relationshipBacked) {
            return false;
        }
    }
}

