/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.fieldaccess;

import java.lang.reflect.Field;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.graph.annotation.RelatedTo;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.graph.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.graph.neo4j.support.GraphDatabaseContext;

public abstract class NodeRelationshipFieldAccessorFactory
implements FieldAccessorFactory<NodeBacked> {
    protected GraphDatabaseContext graphDatabaseContext;

    public NodeRelationshipFieldAccessorFactory(GraphDatabaseContext graphDatabaseContext) {
        this.graphDatabaseContext = graphDatabaseContext;
    }

    protected Class<? extends NodeBacked> targetFrom(Field field) {
        return field.getType();
    }

    protected Class<? extends NodeBacked> targetFrom(RelatedTo relAnnotation) {
        return relAnnotation.elementClass();
    }

    protected Direction dirFrom(RelatedTo relAnnotation) {
        return relAnnotation.direction().toNeo4jDir();
    }

    protected DynamicRelationshipType typeFrom(Field field) {
        return DynamicRelationshipType.withName((String)DelegatingFieldAccessorFactory.getNeo4jPropertyName(field));
    }

    protected DynamicRelationshipType typeFrom(RelatedTo relAnnotation) {
        return DynamicRelationshipType.withName((String)relAnnotation.type());
    }

    protected DynamicRelationshipType typeFrom(Field field, RelatedTo relAnnotation) {
        return "".equals(relAnnotation.type()) ? this.typeFrom(field) : this.typeFrom(relAnnotation);
    }

    protected RelatedTo getRelationshipAnnotation(Field field) {
        return field.getAnnotation(RelatedTo.class);
    }

    protected boolean hasValidRelationshipAnnotation(Field field) {
        boolean hasElementClass;
        RelatedTo relAnnotation = this.getRelationshipAnnotation(field);
        if (relAnnotation == null) {
            return false;
        }
        boolean bl = hasElementClass = !relAnnotation.elementClass().equals(NodeBacked.class);
        if (!hasElementClass) {
            throw new InvalidDataAccessApiUsageException(String.format("Missing mandatory attribute @RelatedTo.elementClass for one-to-N relationship field %s in class: %s", field.getName(), field.getDeclaringClass().getName()));
        }
        return true;
    }
}

