/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.client.result.DeleteResult;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.domain.SearchResult;
import org.springframework.data.domain.SearchResults;
import org.springframework.data.domain.Similarity;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoPage;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.ExecutableAggregationOperation;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.ExecutableRemoveOperation;
import org.springframework.data.mongodb.core.ExecutableUpdateOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.VectorSearchDelegate;
import org.springframework.data.mongodb.repository.util.SliceUtils;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@FunctionalInterface
public interface MongoQueryExecution {
    public @Nullable Object execute(Query var1);

    public static final class UpdateExecution
    implements MongoQueryExecution {
        private final ExecutableUpdateOperation.ExecutableUpdate<?> updateOps;
        private Supplier<UpdateDefinition> updateDefinitionSupplier;
        private final MongoParameterAccessor accessor;

        UpdateExecution(ExecutableUpdateOperation.ExecutableUpdate<?> updateOps, MongoQueryMethod method, Supplier<UpdateDefinition> updateSupplier, MongoParameterAccessor accessor) {
            this.updateOps = updateOps;
            this.updateDefinitionSupplier = updateSupplier;
            this.accessor = accessor;
        }

        @Override
        public Object execute(Query query) {
            return this.updateOps.matching(query.with(this.accessor.getSort())).apply(this.updateDefinitionSupplier.get()).all().getModifiedCount();
        }
    }

    public static final class DeleteExecution<T>
    implements MongoQueryExecution {
        private ExecutableRemoveOperation.ExecutableRemove<T> remove;
        private Type type;

        public DeleteExecution(ExecutableRemoveOperation.ExecutableRemove<T> remove, QueryMethod queryMethod) {
            this.remove = remove;
            this.type = queryMethod.isCollectionQuery() ? Type.FIND_AND_REMOVE_ALL : (queryMethod.isQueryForEntity() && !ClassUtils.isPrimitiveOrWrapper((Class)queryMethod.getReturnedObjectType()) ? Type.FIND_AND_REMOVE_ONE : Type.ALL);
        }

        public DeleteExecution(ExecutableRemoveOperation.ExecutableRemove<T> remove, Type type) {
            this.remove = remove;
            this.type = type;
        }

        @Override
        public @Nullable Object execute(Query query) {
            ExecutableRemoveOperation.TerminatingRemove doRemove = this.remove.matching(query);
            if (Type.ALL.equals((Object)this.type)) {
                DeleteResult result = doRemove.all();
                return result.wasAcknowledged() ? Long.valueOf(result.getDeletedCount()) : Long.valueOf(0L);
            }
            if (Type.FIND_AND_REMOVE_ALL.equals((Object)this.type)) {
                return doRemove.findAndRemove();
            }
            if (Type.FIND_AND_REMOVE_ONE.equals((Object)this.type)) {
                Iterator removed = doRemove.findAndRemove().iterator();
                return removed.hasNext() ? removed.next() : null;
            }
            throw new RuntimeException();
        }

        public static enum Type {
            FIND_AND_REMOVE_ONE,
            FIND_AND_REMOVE_ALL,
            ALL;

        }
    }

    public static final class PagingGeoNearExecution
    extends GeoNearExecution {
        private final ExecutableFindOperation.FindWithQuery<?> operation;
        private final ConvertingParameterAccessor accessor;

        PagingGeoNearExecution(ExecutableFindOperation.FindWithQuery<?> operation, MongoQueryMethod method, ConvertingParameterAccessor accessor) {
            super(operation, method, accessor);
            this.accessor = accessor;
            this.operation = operation;
        }

        @Override
        public Object execute(Query query) {
            NearQuery nearQuery = this.nearQuery(query);
            GeoResults<Object> geoResults = this.doExecuteQuery(nearQuery);
            Page page = PageableExecutionUtils.getPage((List)geoResults.getContent(), (Pageable)this.accessor.getPageable(), () -> this.operation.near(nearQuery).count());
            return new GeoPage(geoResults, this.accessor.getPageable(), page.getTotalElements());
        }
    }

    public static class VectorSearchExecution
    implements MongoQueryExecution {
        private final MongoOperations operations;
        private final TypeInformation<?> returnType;
        private final String collectionName;
        private final Class<?> targetType;
        private final ScoringFunction scoringFunction;
        private final AggregationPipeline pipeline;

        VectorSearchExecution(MongoOperations operations, MongoQueryMethod method, String collectionName, VectorSearchDelegate.QueryContainer queryContainer) {
            this(operations, queryContainer.outputType(), collectionName, method.getReturnType(), queryContainer.pipeline(), queryContainer.scoringFunction());
        }

        public VectorSearchExecution(MongoOperations operations, Class<?> targetType, String collectionName, TypeInformation<?> returnType, AggregationPipeline pipeline, ScoringFunction scoringFunction) {
            this.operations = operations;
            this.returnType = returnType;
            this.collectionName = collectionName;
            this.targetType = targetType;
            this.scoringFunction = scoringFunction;
            this.pipeline = pipeline;
        }

        @Override
        public Object execute(Query query) {
            ExecutableAggregationOperation.TerminatingAggregation executableAggregation = this.operations.aggregateAndReturn(this.targetType).inCollection(this.collectionName).by(TypedAggregation.newAggregation(this.targetType, this.pipeline.getOperations()));
            if (!VectorSearchExecution.isSearchResult(this.returnType)) {
                return executableAggregation.all().getMappedResults();
            }
            AggregationResults<SearchResult> result = executableAggregation.map((raw, container) -> new SearchResult(container.get(), (Score)Similarity.raw((double)raw.getDouble((Object)"__score__"), (ScoringFunction)this.scoringFunction))).all();
            return VectorSearchExecution.isListOfSearchResult(this.returnType) ? result.getMappedResults() : new SearchResults(result.getMappedResults());
        }

        private static boolean isListOfSearchResult(TypeInformation<?> returnType) {
            if (!Collection.class.isAssignableFrom(returnType.getType())) {
                return false;
            }
            TypeInformation componentType = returnType.getComponentType();
            return componentType != null && SearchResult.class.equals((Object)componentType.getType());
        }

        private static boolean isSearchResult(TypeInformation<?> returnType) {
            if (SearchResults.class.isAssignableFrom(returnType.getType())) {
                return true;
            }
            if (!Iterable.class.isAssignableFrom(returnType.getType())) {
                return false;
            }
            TypeInformation componentType = returnType.getComponentType();
            return componentType != null && SearchResult.class.equals((Object)componentType.getType());
        }
    }

    public static class GeoNearExecution
    implements MongoQueryExecution {
        private final ExecutableFindOperation.FindWithQuery<?> operation;
        private final MongoQueryMethod method;
        private final MongoParameterAccessor accessor;

        public GeoNearExecution(ExecutableFindOperation.FindWithQuery<?> operation, MongoQueryMethod method, MongoParameterAccessor accessor) {
            Assert.notNull(operation, (String)"Operation must not be null");
            Assert.notNull((Object)((Object)method), (String)"Method must not be null");
            Assert.notNull((Object)accessor, (String)"Accessor must not be null");
            this.operation = operation;
            this.method = method;
            this.accessor = accessor;
        }

        @Override
        public Object execute(Query query) {
            GeoResults<Object> results = this.doExecuteQuery(query);
            return GeoNearExecution.isListOfGeoResult(this.method.getReturnType()) ? results.getContent() : results;
        }

        GeoResults<Object> doExecuteQuery(Query query) {
            return this.doExecuteQuery(this.nearQuery(query));
        }

        NearQuery nearQuery(Query query) {
            Point nearLocation = this.accessor.getGeoNearLocation();
            Assert.notNull((Object)nearLocation, (String)"[query.location] must not be null");
            NearQuery nearQuery = NearQuery.near(nearLocation);
            if (query != null) {
                nearQuery.query(query);
            }
            Range<Distance> distances = this.accessor.getDistanceRange();
            Assert.notNull(distances, (String)"[query.distances] must not be null");
            distances.getLowerBound().getValue().ifPresent(it -> nearQuery.minDistance((Distance)it).in(it.getMetric()));
            distances.getUpperBound().getValue().ifPresent(it -> nearQuery.maxDistance((Distance)it).in(it.getMetric()));
            Pageable pageable = this.accessor.getPageable();
            return nearQuery.with(pageable);
        }

        GeoResults<Object> doExecuteQuery(NearQuery query) {
            return this.operation.near(query).all();
        }

        private static boolean isListOfGeoResult(TypeInformation<?> returnType) {
            if (!returnType.getType().equals(List.class)) {
                return false;
            }
            TypeInformation componentType = returnType.getComponentType();
            return componentType != null && GeoResult.class.equals((Object)componentType.getType());
        }
    }

    public static final class PagedExecution<T>
    implements MongoQueryExecution {
        private final ExecutableFindOperation.FindWithQuery<T> operation;
        private final Pageable pageable;

        public PagedExecution(ExecutableFindOperation.FindWithQuery<T> operation, Pageable pageable) {
            Assert.notNull(operation, (String)"Operation must not be null");
            Assert.notNull((Object)pageable, (String)"Pageable must not be null");
            this.operation = operation;
            this.pageable = pageable;
        }

        public Page<T> execute(Query query) {
            int overallLimit = query.getLimit();
            ExecutableFindOperation.TerminatingFind<T> matching = this.operation.matching(query);
            query.with(this.pageable);
            if (overallLimit != 0 && this.pageable.getOffset() + (long)this.pageable.getPageSize() > (long)overallLimit) {
                query.limit((int)((long)overallLimit - this.pageable.getOffset()));
            }
            return PageableExecutionUtils.getPage(matching.all(), (Pageable)this.pageable, () -> {
                long count = this.operation.matching(Query.of(query).skip(-1L).limit(-1)).count();
                return overallLimit != 0 ? Math.min(count, (long)overallLimit) : count;
            });
        }
    }

    public static final class SlicedExecution<T>
    implements MongoQueryExecution {
        private final ExecutableFindOperation.FindWithQuery<T> find;
        private final Pageable pageable;

        public SlicedExecution(ExecutableFindOperation.FindWithQuery<T> find, Pageable pageable) {
            Assert.notNull(find, (String)"Find must not be null");
            Assert.notNull((Object)pageable, (String)"Pageable must not be null");
            this.find = find;
            this.pageable = pageable;
        }

        public Slice<T> execute(Query query) {
            int pageSize = this.pageable.getPageSize();
            Query modifiedQuery = SliceUtils.limitResult(query, this.pageable).with(this.pageable.getSort());
            List result = this.find.matching(modifiedQuery).all();
            boolean hasNext = result.size() > pageSize;
            return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, this.pageable, hasNext);
        }
    }
}

