/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.core.ReactiveWrappers;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.ClassUtils;

public class ReactiveMongoQueryMethod
extends MongoQueryMethod {
    private static final TypeInformation<Page> PAGE_TYPE = TypeInformation.of(Page.class);
    private static final TypeInformation<Slice> SLICE_TYPE = TypeInformation.of(Slice.class);
    private final Method method;
    private final Lazy<Boolean> isCollectionQuery;

    public ReactiveMongoQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super(method, metadata, projectionFactory, mappingContext, parametersSource -> new MongoParameters((ParametersSource)parametersSource, MongoParameters.isGeoNearQuery(parametersSource.getMethod()) || ReactiveMongoQueryMethod.isGeoNearQuery(parametersSource.getMethod())));
        this.method = method;
        this.isCollectionQuery = Lazy.of(() -> !this.isPageQuery() && !this.isSliceQuery() && !this.isScrollQuery() && ReactiveWrappers.isMultiValueType((Class)metadata.getReturnType(method).getType()) || super.isCollectionQuery());
    }

    public boolean isCollectionQuery() {
        return (Boolean)this.isCollectionQuery.get();
    }

    @Override
    public boolean isGeoNearQuery() {
        return ReactiveMongoQueryMethod.isGeoNearQuery(this.method);
    }

    private static boolean isGeoNearQuery(Method method) {
        if (ReactiveWrappers.supports(method.getReturnType())) {
            TypeInformation from = TypeInformation.fromReturnTypeOf((Method)method);
            return GeoResult.class.equals((Object)from.getRequiredComponentType().getType());
        }
        return false;
    }

    @Override
    public boolean isModifyingQuery() {
        return super.isModifyingQuery();
    }

    public boolean isQueryForEntity() {
        return super.isQueryForEntity();
    }

    public boolean isStreamQuery() {
        return true;
    }

    public boolean hasReactiveWrapperParameter() {
        Iterator iterator = this.getParameters().iterator();
        while (iterator.hasNext()) {
            MongoParameters.MongoParameter mongoParameter = (MongoParameters.MongoParameter)((Object)iterator.next());
            if (!ReactiveWrapperConverters.supports((Class)mongoParameter.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void verify() {
        if (ReflectionUtils.hasParameterOfType((Method)this.method, Pageable.class)) {
            boolean singleWrapperWithWrappedPageableResult;
            TypeInformation returnType = TypeInformation.fromReturnTypeOf((Method)this.method);
            boolean multiWrapper = ReactiveWrappers.isMultiValueType((Class)returnType.getType());
            boolean bl = singleWrapperWithWrappedPageableResult = ReactiveWrappers.isSingleValueType((Class)returnType.getType()) && (PAGE_TYPE.isAssignableFrom(returnType.getRequiredComponentType()) || SLICE_TYPE.isAssignableFrom(returnType.getRequiredComponentType()));
            if (ReflectionUtils.hasParameterOfType((Method)this.method, Sort.class)) {
                throw new IllegalStateException(String.format("Method must not have Pageable *and* Sort parameter; Use sorting capabilities on Pageable instead; Offending method: %s", this.method));
            }
            if (this.isScrollQuery()) {
                return;
            }
            if (singleWrapperWithWrappedPageableResult) {
                throw new InvalidDataAccessApiUsageException(String.format("'%s.%s' must not use sliced or paged execution; Please use Flux.buffer(size, skip).", ClassUtils.getShortName(this.method.getDeclaringClass()), this.method.getName()));
            }
            if (!multiWrapper) {
                throw new IllegalStateException(String.format("Method has to use a either multi-item reactive wrapper return type or a wrapped Page/Slice type; Offending method: %s", this.method));
            }
        }
        super.verify();
    }
}

