/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GeoNearOperation
implements AggregationOperation {
    private final NearQuery nearQuery;
    private final String distanceField;
    private final @Nullable String indexKey;
    private final @Nullable Long skip;
    private final @Nullable Integer limit;

    public GeoNearOperation(NearQuery nearQuery, String distanceField) {
        this(nearQuery, distanceField, null, nearQuery.getSkip(), null);
    }

    private GeoNearOperation(NearQuery nearQuery, String distanceField, @Nullable String indexKey, @Nullable Long skip, @Nullable Integer limit) {
        Assert.notNull((Object)nearQuery, (String)"NearQuery must not be null");
        Assert.hasLength((String)distanceField, (String)"Distance field must not be null or empty");
        this.nearQuery = nearQuery;
        this.distanceField = distanceField;
        this.indexKey = indexKey;
        this.skip = skip;
        this.limit = limit;
    }

    @Contract(value="_ -> new")
    public GeoNearOperation useIndex(String key) {
        return new GeoNearOperation(this.nearQuery, this.distanceField, key, this.skip, this.limit);
    }

    public GeoNearOperation skip(long skip) {
        return new GeoNearOperation(this.nearQuery, this.distanceField, this.indexKey, skip, this.limit);
    }

    public GeoNearOperation limit(Integer limit) {
        return new GeoNearOperation(this.nearQuery, this.distanceField, this.indexKey, this.skip, limit);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Document command = context.getMappedObject(this.nearQuery.toDocument());
        if (command.containsKey((Object)"query")) {
            Document query = (Document)command.get((Object)"query", Document.class);
            if (query == null || query.isEmpty()) {
                command.remove((Object)"query");
            } else {
                command.replace((Object)"query", (Object)context.getMappedObject(query));
            }
        }
        command.remove((Object)"collation");
        command.put("distanceField", (Object)this.distanceField);
        if (StringUtils.hasText((String)this.indexKey)) {
            command.put("key", (Object)this.indexKey);
        }
        return new Document(this.getOperator(), (Object)command);
    }

    @Override
    public String getOperator() {
        return "$geoNear";
    }

    @Override
    public List<Document> toPipelineStages(AggregationOperationContext context) {
        Document command = this.toDocument(context);
        Number limit = (Number)((Document)command.get((Object)"$geoNear", Document.class)).remove((Object)"num");
        if (limit != null && this.limit != null) {
            limit = this.limit;
        }
        ArrayList<Document> stages = new ArrayList<Document>(3);
        stages.add(command);
        if (this.skip != null && this.skip > 0L) {
            stages.add(new Document("$skip", (Object)this.skip));
        }
        if (limit != null && limit.longValue() > 0L) {
            stages.add(new Document("$limit", (Object)limit.longValue()));
        }
        return stages;
    }
}

