/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.DocumentEnhancingOperation;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.lang.Contract;

public class AddFieldsOperation
extends DocumentEnhancingOperation {
    private AddFieldsOperation(Map<Object, Object> source) {
        super(source);
    }

    public AddFieldsOperation(Object field, @Nullable Object value) {
        this(Collections.singletonMap(field, value));
    }

    public static AddFieldsOperationBuilder builder() {
        return new AddFieldsOperationBuilder();
    }

    public static AddFieldsOperationBuilder.ValueAppender addField(String field) {
        return new AddFieldsOperationBuilder().addField(field);
    }

    @Contract(value="_ -> new")
    public AddFieldsOperation addField(Object field, Object value) {
        LinkedHashMap<Object, Object> target = new LinkedHashMap<Object, Object>(this.getValueMap());
        target.put(field, value);
        return new AddFieldsOperation(target);
    }

    @Contract(value="-> new")
    public AddFieldsOperationBuilder and() {
        return new AddFieldsOperationBuilder(this.getValueMap());
    }

    @Override
    protected String mongoOperator() {
        return "$addFields";
    }

    public static class AddFieldsOperationBuilder {
        private final Map<Object, Object> valueMap;

        private AddFieldsOperationBuilder() {
            this.valueMap = new LinkedHashMap<Object, Object>();
        }

        private AddFieldsOperationBuilder(Map<Object, Object> source) {
            this.valueMap = new LinkedHashMap<Object, Object>(source);
        }

        public AddFieldsOperationBuilder addFieldWithValue(String field, @Nullable Object value) {
            return this.addField(field).withValue(value);
        }

        public AddFieldsOperationBuilder addFieldWithValueOf(String field, Object value) {
            return this.addField(field).withValueOf(value);
        }

        public ValueAppender addField(final String field) {
            return new ValueAppender(){
                final /* synthetic */ AddFieldsOperationBuilder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public AddFieldsOperationBuilder withValue(@Nullable Object value) {
                    this.this$0.valueMap.put(field, value);
                    return this.this$0;
                }

                @Override
                public AddFieldsOperationBuilder withValueOf(Object value) {
                    Object object;
                    Map<Object, Object> map = this.this$0.valueMap;
                    if (value instanceof String) {
                        String stringValue = (String)value;
                        object = Fields.field(stringValue);
                    } else {
                        object = value;
                    }
                    map.put(field, object);
                    return this.this$0;
                }

                @Override
                public AddFieldsOperationBuilder withValueOfExpression(String operation, Object ... values) {
                    this.this$0.valueMap.put(field, new DocumentEnhancingOperation.ExpressionProjection(operation, values));
                    return this.this$0;
                }
            };
        }

        public AddFieldsOperation build() {
            return new AddFieldsOperation(this.valueMap);
        }

        public static interface ValueAppender {
            public AddFieldsOperationBuilder withValue(@Nullable Object var1);

            public AddFieldsOperationBuilder withValueOf(Object var1);

            public AddFieldsOperationBuilder withValueOfExpression(String var1, Object ... var2);
        }
    }
}

