/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.ReadConcernAware;
import org.springframework.data.mongodb.core.ReadPreferenceAware;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.DiskUse;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class AggregationOptions
implements ReadConcernAware,
ReadPreferenceAware {
    private static final String BATCH_SIZE = "batchSize";
    private static final String CURSOR = "cursor";
    private static final String EXPLAIN = "explain";
    private static final String ALLOW_DISK_USE = "allowDiskUse";
    private static final String COLLATION = "collation";
    private static final String COMMENT = "comment";
    private static final String MAX_TIME = "maxTimeMS";
    private static final String HINT = "hint";
    private final DiskUse diskUse;
    private final boolean explain;
    private final Optional<Document> cursor;
    private final Optional<Collation> collation;
    private final Optional<String> comment;
    private final Optional<Object> hint;
    private Optional<ReadConcern> readConcern;
    private Optional<ReadPreference> readPreference;
    private Duration maxTime = Duration.ZERO;
    private ResultOptions resultOptions = ResultOptions.READ;
    private DomainTypeMapping domainTypeMapping = DomainTypeMapping.RELAXED;

    public AggregationOptions(boolean allowDiskUse, boolean explain, @Nullable Document cursor) {
        this(allowDiskUse, explain, cursor, null);
    }

    public AggregationOptions(DiskUse diskUse, boolean explain, @Nullable Document cursor) {
        this(diskUse, explain, cursor, null);
    }

    public AggregationOptions(DiskUse allowDiskUse, boolean explain, @Nullable Document cursor, @Nullable Collation collation) {
        this(allowDiskUse, explain, cursor, collation, null);
    }

    public AggregationOptions(boolean allowDiskUse, boolean explain, @Nullable Document cursor, @Nullable Collation collation) {
        this(DiskUse.of(allowDiskUse), explain, cursor, collation, null, null);
    }

    public AggregationOptions(boolean allowDiskUse, boolean explain, @Nullable Document cursor, @Nullable Collation collation, @Nullable String comment) {
        this(allowDiskUse ? DiskUse.ALLOW : DiskUse.DENY, explain, cursor, collation, comment, null);
    }

    public AggregationOptions(DiskUse allowDiskUse, boolean explain, @Nullable Document cursor, @Nullable Collation collation, @Nullable String comment) {
        this(allowDiskUse, explain, cursor, collation, comment, null);
    }

    private AggregationOptions(DiskUse diskUse, boolean explain, @Nullable Document cursor, @Nullable Collation collation, @Nullable String comment, @Nullable Object hint) {
        Assert.notNull((Object)((Object)diskUse), (String)"DiskUse must not be null");
        this.diskUse = diskUse;
        this.explain = explain;
        this.cursor = Optional.ofNullable(cursor);
        this.collation = Optional.ofNullable(collation);
        this.comment = Optional.ofNullable(comment);
        this.hint = Optional.ofNullable(hint);
        this.readConcern = Optional.empty();
        this.readPreference = Optional.empty();
    }

    public AggregationOptions(boolean allowDiskUse, boolean explain, int cursorBatchSize) {
        this(allowDiskUse, explain, AggregationOptions.createCursor(cursorBatchSize), null);
    }

    public static AggregationOptions fromDocument(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        Boolean allowDiskUse = (Boolean)document.get((Object)ALLOW_DISK_USE, Boolean.class);
        boolean explain = document.getBoolean((Object)EXPLAIN, false);
        Document cursor = (Document)document.get((Object)CURSOR, Document.class);
        Collation collation = document.containsKey((Object)COLLATION) ? Collation.from((Document)document.get((Object)COLLATION, Document.class)) : null;
        String comment = document.getString((Object)COMMENT);
        Document hint = (Document)document.get((Object)HINT, Document.class);
        AggregationOptions options = new AggregationOptions(DiskUse.of(allowDiskUse), explain, cursor, collation, comment, hint);
        if (document.containsKey((Object)MAX_TIME)) {
            options.maxTime = Duration.ofMillis(document.getLong((Object)MAX_TIME));
        }
        return options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isAllowDiskUse() {
        return this.diskUse.equals((Object)DiskUse.ALLOW);
    }

    public boolean isAllowDiskUseSet() {
        return !this.diskUse.equals((Object)DiskUse.DEFAULT);
    }

    public boolean isExplain() {
        return this.explain;
    }

    public @Nullable Integer getCursorBatchSize() {
        if (this.cursor.filter(val -> val.containsKey((Object)BATCH_SIZE)).isPresent()) {
            return (Integer)this.cursor.get().get((Object)BATCH_SIZE, Integer.class);
        }
        return null;
    }

    public Optional<Document> getCursor() {
        return this.cursor;
    }

    public Optional<Collation> getCollation() {
        return this.collation;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public Optional<Document> getHint() {
        return this.hint.map(it -> {
            String hintString;
            if (it instanceof Document) {
                Document doc = (Document)it;
                return doc;
            }
            if (it instanceof String && BsonUtils.isJsonDocument(hintString = (String)it)) {
                return BsonUtils.parse(hintString, null);
            }
            throw new IllegalStateException("Unable to read hint of type %s".formatted(it.getClass()));
        });
    }

    public Optional<Object> getHintObject() {
        return this.hint;
    }

    @Override
    public boolean hasReadConcern() {
        return this.readConcern.isPresent();
    }

    @Override
    public @Nullable ReadConcern getReadConcern() {
        return this.readConcern.orElse(null);
    }

    @Override
    public boolean hasReadPreference() {
        return this.readPreference.isPresent();
    }

    @Override
    public @Nullable ReadPreference getReadPreference() {
        return this.readPreference.orElse(null);
    }

    public Duration getMaxTime() {
        return this.maxTime;
    }

    public boolean isSkipResults() {
        return ResultOptions.SKIP.equals((Object)this.resultOptions);
    }

    public DomainTypeMapping getDomainTypeMapping() {
        return this.domainTypeMapping;
    }

    Document applyAndReturnPotentiallyChangedCommand(Document command) {
        Document result = new Document((Map)command);
        if (this.isAllowDiskUseSet() && !result.containsKey((Object)ALLOW_DISK_USE)) {
            result.put(ALLOW_DISK_USE, (Object)this.isAllowDiskUse());
        }
        if (this.explain && !result.containsKey((Object)EXPLAIN)) {
            result.put(EXPLAIN, (Object)this.explain);
        }
        if (result.containsKey((Object)HINT)) {
            this.hint.ifPresent(val -> result.append(HINT, val));
        }
        if (!result.containsKey((Object)CURSOR)) {
            this.cursor.ifPresent(val -> result.put(CURSOR, val));
        }
        if (!result.containsKey((Object)COLLATION)) {
            this.collation.map(Collation::toDocument).ifPresent(val -> result.append(COLLATION, val));
        }
        if (this.hasExecutionTimeLimit() && !result.containsKey((Object)MAX_TIME)) {
            result.append(MAX_TIME, (Object)this.maxTime.toMillis());
        }
        return result;
    }

    public Document toDocument() {
        Document document = new Document();
        if (this.isAllowDiskUseSet()) {
            document.put(ALLOW_DISK_USE, (Object)this.isAllowDiskUse());
        }
        document.put(EXPLAIN, (Object)this.explain);
        this.cursor.ifPresent(val -> document.put(CURSOR, val));
        this.collation.ifPresent(val -> document.append(COLLATION, (Object)val.toDocument()));
        this.comment.ifPresent(val -> document.append(COMMENT, val));
        this.hint.ifPresent(val -> document.append(HINT, val));
        if (this.hasExecutionTimeLimit()) {
            document.append(MAX_TIME, (Object)this.maxTime.toMillis());
        }
        return document;
    }

    public boolean hasExecutionTimeLimit() {
        return !this.maxTime.isZero() && !this.maxTime.isNegative();
    }

    public String toString() {
        return this.toDocument().toJson();
    }

    static Document createCursor(int cursorBatchSize) {
        return new Document(BATCH_SIZE, (Object)cursorBatchSize);
    }

    private static enum ResultOptions {
        SKIP,
        READ;

    }

    public static enum DomainTypeMapping {
        STRICT,
        RELAXED,
        NONE;

    }

    public static class Builder {
        private DiskUse diskUse = DiskUse.DEFAULT;
        private boolean explain;
        private @Nullable Document cursor;
        private @Nullable Collation collation;
        private @Nullable String comment;
        private @Nullable Object hint;
        private @Nullable ReadConcern readConcern;
        private @Nullable ReadPreference readPreference;
        private @Nullable Duration maxTime;
        private @Nullable ResultOptions resultOptions;
        private @Nullable DomainTypeMapping domainTypeMapping;

        @Contract(value="_ -> this")
        public Builder allowDiskUse(boolean allowDiskUse) {
            return this.diskUse(DiskUse.of(allowDiskUse));
        }

        @Contract(value="_ -> this")
        public Builder diskUse(DiskUse diskUse) {
            Assert.notNull((Object)((Object)diskUse), (String)"DiskUse must not be null");
            this.diskUse = diskUse;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder explain(boolean explain) {
            this.explain = explain;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder cursor(Document cursor) {
            this.cursor = cursor;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder cursorBatchSize(int batchSize) {
            this.cursor = AggregationOptions.createCursor(batchSize);
            return this;
        }

        @Contract(value="_ -> this")
        public Builder collation(@Nullable Collation collation) {
            this.collation = collation;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder hint(@Nullable Document hint) {
            this.hint = hint;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder hint(@Nullable String indexName) {
            this.hint = indexName;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder readConcern(@Nullable ReadConcern readConcern) {
            this.readConcern = readConcern;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder readPreference(@Nullable ReadPreference readPreference) {
            this.readPreference = readPreference;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder maxTime(@Nullable Duration maxTime) {
            this.maxTime = maxTime;
            return this;
        }

        @Contract(value="-> this")
        public Builder skipOutput() {
            this.resultOptions = ResultOptions.SKIP;
            return this;
        }

        @Contract(value="-> this")
        public Builder strictMapping() {
            this.domainTypeMapping = DomainTypeMapping.STRICT;
            return this;
        }

        @Contract(value="-> this")
        public Builder relaxedMapping() {
            this.domainTypeMapping = DomainTypeMapping.RELAXED;
            return this;
        }

        @Contract(value="-> this")
        public Builder noMapping() {
            this.domainTypeMapping = DomainTypeMapping.NONE;
            return this;
        }

        @Contract(value="-> new")
        public AggregationOptions build() {
            AggregationOptions options = new AggregationOptions(this.diskUse, this.explain, this.cursor, this.collation, this.comment, this.hint);
            if (this.maxTime != null) {
                options.maxTime = this.maxTime;
            }
            if (this.resultOptions != null) {
                options.resultOptions = this.resultOptions;
            }
            if (this.domainTypeMapping != null) {
                options.domainTypeMapping = this.domainTypeMapping;
            }
            if (this.readConcern != null) {
                options.readConcern = Optional.of(this.readConcern);
            }
            if (this.readPreference != null) {
                options.readPreference = Optional.of(this.readPreference);
            }
            return options;
        }
    }
}

