/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.aggregation.AddFieldsOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationRenderer;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.aggregation.AggregationUpdate;
import org.springframework.data.mongodb.core.aggregation.BasicAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.BucketAutoOperation;
import org.springframework.data.mongodb.core.aggregation.BucketOperation;
import org.springframework.data.mongodb.core.aggregation.CountOperation;
import org.springframework.data.mongodb.core.aggregation.FacetOperation;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.GeoNearOperation;
import org.springframework.data.mongodb.core.aggregation.GraphLookupOperation;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.LimitOperation;
import org.springframework.data.mongodb.core.aggregation.LookupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.MergeOperation;
import org.springframework.data.mongodb.core.aggregation.OutOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.aggregation.RedactOperation;
import org.springframework.data.mongodb.core.aggregation.ReplaceRootOperation;
import org.springframework.data.mongodb.core.aggregation.SampleOperation;
import org.springframework.data.mongodb.core.aggregation.SkipOperation;
import org.springframework.data.mongodb.core.aggregation.SortByCountOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.data.mongodb.core.aggregation.SystemVariable;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.aggregation.UnwindOperation;
import org.springframework.data.mongodb.core.aggregation.VectorSearchOperation;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.timeseries.Granularity;
import org.springframework.util.Assert;

public class Aggregation {
    public static final String ROOT = SystemVariable.ROOT.toString();
    public static final String CURRENT = SystemVariable.CURRENT.toString();
    public static final String REMOVE = SystemVariable.REMOVE.toString();
    public static final AggregationOperationContext DEFAULT_CONTEXT = AggregationOperationRenderer.DEFAULT_CONTEXT;
    public static final AggregationOptions DEFAULT_OPTIONS = Aggregation.newAggregationOptions().build();
    protected final AggregationPipeline pipeline;
    private final AggregationOptions options;

    public static Aggregation newAggregation(List<? extends AggregationOperation> operations) {
        return Aggregation.newAggregation(operations.toArray(new AggregationOperation[operations.size()]));
    }

    public static Aggregation newAggregation(AggregationOperation ... operations) {
        return new Aggregation(operations);
    }

    public static AggregationUpdate newUpdate(AggregationOperation ... operations) {
        return AggregationUpdate.from(Arrays.asList(operations));
    }

    public Aggregation withOptions(AggregationOptions options) {
        Assert.notNull((Object)options, (String)"AggregationOptions must not be null");
        return new Aggregation(this.pipeline.getOperations(), options);
    }

    public static <T> TypedAggregation<T> newAggregation(Class<T> type, List<? extends AggregationOperation> operations) {
        return Aggregation.newAggregation(type, operations.toArray(new AggregationOperation[operations.size()]));
    }

    public static <T> TypedAggregation<T> newAggregation(Class<T> type, AggregationOperation ... operations) {
        return new TypedAggregation<T>(type, operations);
    }

    protected Aggregation(AggregationOperation ... aggregationOperations) {
        this(Aggregation.asAggregationList(aggregationOperations));
    }

    protected static List<AggregationOperation> asAggregationList(AggregationOperation ... aggregationOperations) {
        Assert.notEmpty((Object[])aggregationOperations, (String)"AggregationOperations must not be null or empty");
        return Arrays.asList(aggregationOperations);
    }

    protected Aggregation(List<AggregationOperation> aggregationOperations) {
        this(aggregationOperations, DEFAULT_OPTIONS);
    }

    protected Aggregation(List<AggregationOperation> aggregationOperations, AggregationOptions options) {
        Assert.notNull(aggregationOperations, (String)"AggregationOperations must not be null");
        Assert.notNull((Object)options, (String)"AggregationOptions must not be null");
        this.pipeline = new AggregationPipeline(aggregationOperations);
        this.options = options;
    }

    public AggregationOptions getOptions() {
        return this.options;
    }

    public static String previousOperation() {
        return FieldName.ID.name();
    }

    public static AddFieldsOperation.AddFieldsOperationBuilder addFields() {
        return AddFieldsOperation.builder();
    }

    public static AggregationOperation stage(Bson aggregationOperation) {
        return new BasicAggregationOperation(aggregationOperation);
    }

    public static AggregationOperation stage(String json) {
        return new BasicAggregationOperation(json);
    }

    public static ProjectionOperation project(String ... fields) {
        return Aggregation.project(Aggregation.fields(fields));
    }

    public static ProjectionOperation project(Fields fields) {
        return new ProjectionOperation(fields);
    }

    public static ProjectionOperation project(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null");
        return new ProjectionOperation(type);
    }

    public static UnwindOperation unwind(String field) {
        return new UnwindOperation(Fields.field(field));
    }

    public static ReplaceRootOperation replaceRoot(String fieldName) {
        return ReplaceRootOperation.builder().withValueOf(fieldName);
    }

    public static ReplaceRootOperation replaceRoot(AggregationExpression aggregationExpression) {
        return ReplaceRootOperation.builder().withValueOf(aggregationExpression);
    }

    public static ReplaceRootOperation.ReplaceRootOperationBuilder replaceRoot() {
        return ReplaceRootOperation.builder();
    }

    public static UnwindOperation unwind(String field, boolean preserveNullAndEmptyArrays) {
        return new UnwindOperation(Fields.field(field), preserveNullAndEmptyArrays);
    }

    public static UnwindOperation unwind(String field, String arrayIndex) {
        return new UnwindOperation(Fields.field(field), Fields.field(arrayIndex), false);
    }

    public static UnwindOperation unwind(String field, String arrayIndex, boolean preserveNullAndEmptyArrays) {
        return new UnwindOperation(Fields.field(field), Fields.field(arrayIndex), preserveNullAndEmptyArrays);
    }

    public static GroupOperation group(String ... fields) {
        return Aggregation.group(Aggregation.fields(fields));
    }

    public static GroupOperation group(Fields fields) {
        return new GroupOperation(fields);
    }

    public static GraphLookupOperation.StartWithBuilder graphLookup(String fromCollection) {
        return GraphLookupOperation.builder().from(fromCollection);
    }

    public static VectorSearchOperation.PathContributor vectorSearch(String indexName) {
        Assert.hasText((String)indexName, (String)"Index name must not be null or empty");
        return VectorSearchOperation.search(indexName);
    }

    public static SortOperation sort(Sort sort) {
        return new SortOperation(sort);
    }

    public static SortOperation sort(Sort.Direction direction, String ... fields) {
        return new SortOperation(Sort.by((Sort.Direction)direction, (String[])fields));
    }

    public static SortByCountOperation sortByCount(String field) {
        return new SortByCountOperation(Fields.field(field));
    }

    public static SortByCountOperation sortByCount(AggregationExpression groupAndSortExpression) {
        return new SortByCountOperation(groupAndSortExpression);
    }

    public static SkipOperation skip(long elementsToSkip) {
        return new SkipOperation(elementsToSkip);
    }

    public static LimitOperation limit(long maxElements) {
        return new LimitOperation(maxElements);
    }

    public static SampleOperation sample(long sampleSize) {
        return new SampleOperation(sampleSize);
    }

    public static MatchOperation match(Criteria criteria) {
        return new MatchOperation(criteria);
    }

    public static MatchOperation match(CriteriaDefinition criteria) {
        return new MatchOperation(criteria);
    }

    public static MatchOperation match(AggregationExpression expression) {
        return new MatchOperation(expression);
    }

    public static GeoNearOperation geoNear(NearQuery query, String distanceField) {
        return new GeoNearOperation(query, distanceField);
    }

    public static MergeOperation.MergeOperationBuilder merge() {
        return MergeOperation.builder();
    }

    public static OutOperation out(String outCollectionName) {
        return new OutOperation(outCollectionName);
    }

    public static OutOperation out(String outCollectionName, CollectionOptions.TimeSeriesOptions timeSeriesOptions) {
        return new OutOperation(outCollectionName).timeSeries(timeSeriesOptions);
    }

    public static OutOperation out(String outCollectionName, String timeField) {
        return new OutOperation(outCollectionName).timeSeries(timeField);
    }

    public static OutOperation out(String outCollectionName, String timeField, @Nullable String metaField, @Nullable Granularity granularity) {
        return new OutOperation(outCollectionName).timeSeries(timeField, metaField, granularity);
    }

    public static BucketOperation bucket(String groupByField) {
        return new BucketOperation(Fields.field(groupByField));
    }

    public static BucketOperation bucket(AggregationExpression groupByExpression) {
        return new BucketOperation(groupByExpression);
    }

    public static BucketAutoOperation bucketAuto(String groupByField, int buckets) {
        return new BucketAutoOperation(Fields.field(groupByField), buckets);
    }

    public static BucketAutoOperation bucketAuto(AggregationExpression groupByExpression, int buckets) {
        return new BucketAutoOperation(groupByExpression, buckets);
    }

    public static FacetOperation facet() {
        return FacetOperation.EMPTY;
    }

    public static FacetOperation.FacetOperationBuilder facet(AggregationOperation ... aggregationOperations) {
        return Aggregation.facet().and(aggregationOperations);
    }

    public static LookupOperation lookup(String from, String localField, String foreignField, String as) {
        return Aggregation.lookup(Fields.field(from), Fields.field(localField), Fields.field(foreignField), Fields.field(as));
    }

    public static LookupOperation lookup(Field from, Field localField, Field foreignField, Field as) {
        return new LookupOperation(from, localField, foreignField, as);
    }

    public static LookupOperation.LookupOperationBuilder lookup() {
        return new LookupOperation.LookupOperationBuilder();
    }

    public static CountOperation.CountOperationBuilder count() {
        return new CountOperation.CountOperationBuilder();
    }

    public static RedactOperation redact(AggregationExpression condition) {
        return new RedactOperation(condition);
    }

    public static Fields fields(String ... fields) {
        return Fields.fields(fields);
    }

    public static Fields bind(String name, String target) {
        return Fields.from(Fields.field(name, target));
    }

    public static AggregationOptions.Builder newAggregationOptions() {
        return new AggregationOptions.Builder();
    }

    public List<Document> toPipeline(AggregationOperationContext rootContext) {
        return this.pipeline.toDocuments(rootContext);
    }

    public AggregationPipeline getPipeline() {
        return this.pipeline;
    }

    public Document toDocument(String inputCollectionName, AggregationOperationContext rootContext) {
        Document command = new Document("aggregate", (Object)inputCollectionName);
        command.put("pipeline", this.toPipeline(rootContext));
        return this.options.applyAndReturnPotentiallyChangedCommand(command);
    }

    public String toString() {
        return SerializationUtils.serializeToJsonSafely(this.toDocument("__collection__", DEFAULT_CONTEXT));
    }
}

