/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.ArrayList;
import java.util.Iterator;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Vector;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.aggregation.VectorSearchOperation;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.VectorSearch;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryCreator;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

class VectorSearchDelegate {
    private final VectorSearchQueryFactory queryFactory;
    private final VectorSearchOperation.SearchType searchType;
    private final String indexName;
    private final @Nullable Integer numCandidates;
    private final @Nullable String numCandidatesExpression;
    private final Limit limit;
    private final @Nullable String limitExpression;
    private final MongoConverter converter;

    VectorSearchDelegate(MongoQueryMethod method, MongoConverter converter, ValueExpressionDelegate delegate) {
        ValueExpression expression;
        VectorSearch vectorSearch = method.findAnnotatedVectorSearch().orElseThrow();
        this.searchType = vectorSearch.searchType();
        this.indexName = method.getAnnotatedHint();
        if (StringUtils.hasText((String)vectorSearch.numCandidates())) {
            expression = delegate.getValueExpressionParser().parse(vectorSearch.numCandidates());
            if (expression.isLiteral()) {
                this.numCandidates = Integer.parseInt(vectorSearch.numCandidates());
                this.numCandidatesExpression = null;
            } else {
                this.numCandidates = null;
                this.numCandidatesExpression = vectorSearch.numCandidates();
            }
        } else {
            this.numCandidates = null;
            this.numCandidatesExpression = null;
        }
        if (StringUtils.hasText((String)vectorSearch.limit())) {
            expression = delegate.getValueExpressionParser().parse(vectorSearch.limit());
            if (expression.isLiteral()) {
                this.limit = Limit.of((int)Integer.parseInt(vectorSearch.limit()));
                this.limitExpression = null;
            } else {
                this.limit = Limit.unlimited();
                this.limitExpression = vectorSearch.limit();
            }
        } else {
            this.limit = Limit.unlimited();
            this.limitExpression = null;
        }
        this.converter = converter;
        this.queryFactory = StringUtils.hasText((String)vectorSearch.filter()) ? (StringUtils.hasText((String)vectorSearch.path()) ? new AnnotatedQueryFactory(vectorSearch.filter(), vectorSearch.path()) : new AnnotatedQueryFactory(vectorSearch.filter(), method.getEntityInformation().getCollectionEntity())) : new PartTreeQueryFactory(new PartTree(method.getName(), method.getResultProcessor().getReturnedType().getDomainType()), converter.getMappingContext());
    }

    QueryContainer createQuery(ValueExpressionEvaluator evaluator, ResultProcessor processor, MongoParameterAccessor accessor, @Nullable Class<?> typeToRead, ParameterBindingDocumentCodec codec, ParameterBindingContext context) {
        String scoreField = "__score__";
        Class outputType = typeToRead != null ? typeToRead : processor.getReturnedType().getReturnedType();
        VectorSearchInput vectorSearchInput = this.createSearchInput(evaluator, accessor, codec, context);
        AggregationPipeline pipeline = this.createVectorSearchPipeline(vectorSearchInput, scoreField, outputType, accessor, evaluator);
        return new QueryContainer(vectorSearchInput.path, scoreField, vectorSearchInput.query, pipeline, this.searchType, outputType, this.getSimilarityFunction(accessor), this.indexName);
    }

    AggregationPipeline createVectorSearchPipeline(VectorSearchInput input, String scoreField, Class<?> outputType, MongoParameterAccessor accessor, ValueExpressionEvaluator evaluator) {
        Vector vector = accessor.getVector();
        Score score = accessor.getScore();
        Range distance = accessor.getScoreRange();
        Limit limit = Limit.of((int)input.query().getLimit());
        ArrayList<AggregationOperation> stages = new ArrayList<AggregationOperation>();
        VectorSearchOperation $vectorSearch = Aggregation.vectorSearch(this.indexName).path(input.path()).vector(vector).limit(limit);
        Integer candidates = null;
        if (this.numCandidatesExpression != null) {
            candidates = ((Number)evaluator.evaluate(this.numCandidatesExpression)).intValue();
        } else if (this.numCandidates != null) {
            candidates = this.numCandidates;
        } else if (input.query().isLimited() && (this.searchType == VectorSearchOperation.SearchType.ANN || this.searchType == VectorSearchOperation.SearchType.DEFAULT)) {
            candidates = input.query().getLimit() * 20;
        }
        if (candidates != null) {
            $vectorSearch = $vectorSearch.numCandidates(candidates);
        }
        $vectorSearch = $vectorSearch.filter(input.query.getQueryObject());
        $vectorSearch = $vectorSearch.searchType(this.searchType);
        $vectorSearch = $vectorSearch.withSearchScore(scoreField);
        if (score != null) {
            $vectorSearch = $vectorSearch.withFilterBySore(c -> c.gt(score.getValue()));
        } else if (distance.getLowerBound().isBounded() || distance.getUpperBound().isBounded()) {
            $vectorSearch = $vectorSearch.withFilterBySore(c -> {
                Range.Bound upper;
                Range.Bound lower = distance.getLowerBound();
                if (lower.isBounded()) {
                    double value = ((Score)lower.getValue().get()).getValue();
                    if (lower.isInclusive()) {
                        c.gte(value);
                    } else {
                        c.gt(value);
                    }
                }
                if ((upper = distance.getUpperBound()).isBounded()) {
                    double value = ((Score)upper.getValue().get()).getValue();
                    if (upper.isInclusive()) {
                        c.lte(value);
                    } else {
                        c.lt(value);
                    }
                }
            });
        }
        stages.add($vectorSearch);
        if (input.query().isSorted()) {
            stages.add(ctx -> {
                Document mappedSort = ctx.getMappedObject(input.query().getSortObject(), outputType);
                mappedSort.append(scoreField, (Object)-1);
                return ctx.getMappedObject(new Document("$sort", (Object)mappedSort));
            });
        } else {
            stages.add(Aggregation.sort(Sort.Direction.DESC, scoreField));
        }
        return new AggregationPipeline(stages);
    }

    private VectorSearchInput createSearchInput(ValueExpressionEvaluator evaluator, MongoParameterAccessor accessor, ParameterBindingDocumentCodec codec, ParameterBindingContext context) {
        VectorSearchInput input = this.queryFactory.createQuery(accessor, codec, context);
        Limit limit = this.getLimit(evaluator, accessor);
        if (!input.query.isLimited() || input.query.isLimited() && !limit.isUnlimited()) {
            input.query().limit(limit);
        }
        return input;
    }

    private Limit getLimit(ValueExpressionEvaluator evaluator, MongoParameterAccessor accessor) {
        Object value;
        if (this.limitExpression != null && (value = evaluator.evaluate(this.limitExpression)) != null) {
            if (value instanceof Limit) {
                Limit l = (Limit)value;
                return l;
            }
            if (value instanceof Number) {
                Number n = (Number)value;
                return Limit.of((int)n.intValue());
            }
            if (value instanceof String) {
                String s = (String)value;
                return Limit.of((int)((Integer)NumberUtils.parseNumber((String)s, Integer.class)));
            }
            throw new IllegalArgumentException("Invalid type for Limit. Found [%s], expected Limit or Number");
        }
        if (this.limit.isLimited()) {
            return this.limit;
        }
        return accessor.getLimit();
    }

    public String getQueryString() {
        return this.queryFactory.getQueryString();
    }

    ScoringFunction getSimilarityFunction(MongoParameterAccessor accessor) {
        Score score = accessor.getScore();
        if (score != null) {
            return score.getFunction();
        }
        Range scoreRange = accessor.getScoreRange();
        if (scoreRange != null) {
            if (scoreRange.getUpperBound().isBounded()) {
                return ((Score)scoreRange.getUpperBound().getValue().get()).getFunction();
            }
            if (scoreRange.getLowerBound().isBounded()) {
                return ((Score)scoreRange.getLowerBound().getValue().get()).getFunction();
            }
        }
        return ScoringFunction.unspecified();
    }

    private static class AnnotatedQueryFactory
    implements VectorSearchQueryFactory {
        private final String query;
        private final String path;

        AnnotatedQueryFactory(String query, String path) {
            this.query = query;
            this.path = path;
        }

        AnnotatedQueryFactory(String query, MongoPersistentEntity<?> entity) {
            this.query = query;
            String path = null;
            Iterator iterator = entity.iterator();
            while (iterator.hasNext()) {
                MongoPersistentProperty property = (MongoPersistentProperty)iterator.next();
                if (!Vector.class.isAssignableFrom(property.getType())) continue;
                path = property.getFieldName();
                break;
            }
            if (path == null) {
                throw new InvalidMongoDbApiUsageException("Cannot find Vector Search property in entity [%s]".formatted(entity.getName()));
            }
            this.path = path;
        }

        @Override
        public VectorSearchInput createQuery(MongoParameterAccessor parameterAccessor, ParameterBindingDocumentCodec codec, ParameterBindingContext context) {
            Document queryObject = codec.decode(this.query, context);
            Query query = new BasicQuery(queryObject);
            Sort sort = parameterAccessor.getSort();
            if (sort.isSorted()) {
                query = query.with(sort);
            }
            return new VectorSearchInput(this.path, query);
        }

        @Override
        public String getQueryString() {
            return this.query;
        }
    }

    private static interface VectorSearchQueryFactory {
        public VectorSearchInput createQuery(MongoParameterAccessor var1, ParameterBindingDocumentCodec var2, ParameterBindingContext var3);

        public String getQueryString();
    }

    private class PartTreeQueryFactory
    implements VectorSearchQueryFactory {
        private final String path;
        private final PartTree tree;

        PartTreeQueryFactory(PartTree tree, MappingContext<?, MongoPersistentProperty> context) {
            String path = null;
            block0: for (PartTree.OrPart part : tree) {
                for (Part p : part) {
                    PersistentPropertyPath ppp;
                    MongoPersistentProperty property;
                    if (p.getType() != Part.Type.SIMPLE_PROPERTY && p.getType() != Part.Type.NEAR && p.getType() != Part.Type.WITHIN && p.getType() != Part.Type.BETWEEN || !Vector.class.isAssignableFrom((property = (MongoPersistentProperty)(ppp = context.getPersistentPropertyPath(p.getProperty())).getLeafProperty()).getType())) continue;
                    path = p.getProperty().toDotPath();
                    continue block0;
                }
            }
            if (path == null) {
                throw new InvalidMongoDbApiUsageException("No Simple Property/Near/Within/Between part found for a Vector property");
            }
            this.path = path;
            this.tree = tree;
        }

        @Override
        public VectorSearchInput createQuery(MongoParameterAccessor parameterAccessor, ParameterBindingDocumentCodec codec, ParameterBindingContext context) {
            MongoQueryCreator creator = new MongoQueryCreator(this.tree, parameterAccessor, VectorSearchDelegate.this.converter.getMappingContext(), false, true);
            Query query = (Query)creator.createQuery(parameterAccessor.getSort());
            if (this.tree.isLimiting()) {
                query.limit(this.tree.getMaxResults());
            }
            return new VectorSearchInput(this.path, query);
        }

        @Override
        public String getQueryString() {
            return "";
        }
    }

    private record VectorSearchInput(String path, Query query) {
    }

    record QueryContainer(String path, String scoreField, Query query, AggregationPipeline pipeline, VectorSearchOperation.SearchType searchType, Class<?> outputType, ScoringFunction scoringFunction, String index) {
    }
}

