/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.ReadPreference;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Meta;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.CollationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

abstract class AggregationUtils {
    private AggregationUtils() {
    }

    static AggregationOptions.Builder applyCollation(AggregationOptions.Builder builder, @Nullable String collationExpression, ConvertingParameterAccessor accessor, ValueExpressionEvaluator evaluator) {
        Collation collation = CollationUtils.computeCollation(collationExpression, accessor, evaluator);
        return collation == null ? builder : builder.collation(collation);
    }

    static AggregationOptions.Builder applyMeta(AggregationOptions.Builder builder, MongoQueryMethod queryMethod) {
        Meta meta = queryMethod.getQueryMetaAttributes();
        if (meta.hasComment()) {
            builder.comment(meta.getComment());
        }
        if (meta.getCursorBatchSize() != null) {
            builder.cursorBatchSize(meta.getCursorBatchSize());
        }
        if (meta.hasMaxTime()) {
            builder.maxTime(Duration.ofMillis(meta.getRequiredMaxTimeMsec()));
        }
        if (meta.getAllowDiskUse() != null) {
            builder.allowDiskUse(meta.getAllowDiskUse());
        }
        return builder;
    }

    static AggregationOptions.Builder applyHint(AggregationOptions.Builder builder, MongoQueryMethod queryMethod) {
        if (!queryMethod.hasAnnotatedHint()) {
            return builder;
        }
        return builder.hint(queryMethod.getAnnotatedHint());
    }

    static AggregationOptions.Builder applyReadPreference(AggregationOptions.Builder builder, MongoQueryMethod queryMethod) {
        if (!queryMethod.hasAnnotatedReadPreference()) {
            return builder;
        }
        return builder.readPreference(ReadPreference.valueOf((String)queryMethod.getAnnotatedReadPreference()));
    }

    static AggregationOptions computeOptions(MongoQueryMethod method, ConvertingParameterAccessor accessor, AggregationPipeline pipeline, ValueExpressionEvaluator evaluator) {
        AggregationOptions.Builder builder = Aggregation.newAggregationOptions();
        AggregationUtils.applyCollation(builder, method.getAnnotatedCollation(), accessor, evaluator);
        AggregationUtils.applyMeta(builder, method);
        AggregationUtils.applyHint(builder, method);
        AggregationUtils.applyReadPreference(builder, method);
        TypeInformation returnType = method.getReturnType();
        if (returnType.getComponentType() != null) {
            returnType = returnType.getRequiredComponentType();
        }
        if (ReflectionUtils.isVoid((Class)returnType.getType()) && pipeline.isOutOrMerge()) {
            builder.skipOutput();
        }
        return builder.build();
    }

    static <T> @Nullable T doAggregate(AggregationPipeline pipeline, MongoQueryMethod method, ResultProcessor processor, ConvertingParameterAccessor accessor, Function<MongoParameterAccessor, ValueExpressionEvaluator> evaluatorFunction, AggregationCallback<T> callback) {
        Class sourceType = method.getDomainClass();
        ReturnedType returnedType = processor.getReturnedType();
        TypeInformation returnType = method.getReturnType();
        Class returnElementType = (returnType.getComponentType() != null ? returnType.getRequiredComponentType() : returnType).getType();
        boolean isRawAggregationResult = ClassUtils.isAssignable(AggregationResults.class, (Class)method.getReturnedObjectType());
        Class entityType = returnElementType.equals(Document.class) ? sourceType : returnElementType;
        AggregationUtils.appendSortIfPresent(pipeline, accessor, entityType);
        if (method.isSliceQuery()) {
            AggregationUtils.appendLimitAndOffsetIfPresent(pipeline, accessor, LongUnaryOperator.identity(), limit -> limit + 1);
        } else {
            AggregationUtils.appendLimitAndOffsetIfPresent(pipeline, accessor);
        }
        AggregationOptions options = AggregationUtils.computeOptions(method, accessor, pipeline, evaluatorFunction.apply(accessor));
        TypedAggregation aggregation = new TypedAggregation(sourceType, pipeline.getOperations(), options);
        boolean isSimpleReturnType = MongoSimpleTypes.HOLDER.isSimpleType(returnElementType);
        Class typeToRead = isSimpleReturnType ? Document.class : (isRawAggregationResult ? returnElementType : (returnedType.isProjecting() ? (returnedType.getReturnedType().isInterface() ? Document.class : returnedType.getReturnedType()) : entityType));
        return callback.doAggregate(aggregation, sourceType, typeToRead, returnElementType, isSimpleReturnType, isRawAggregationResult);
    }

    static AggregationPipeline computePipeline(AbstractMongoQuery mongoQuery, MongoQueryMethod method, ConvertingParameterAccessor accessor) {
        return new AggregationPipeline(mongoQuery.parseAggregationPipeline(method.getAnnotatedAggregation(), accessor));
    }

    static void appendSortIfPresent(AggregationPipeline aggregationPipeline, ConvertingParameterAccessor accessor, @Nullable Class<?> targetType) {
        if (accessor.getSort().isUnsorted()) {
            return;
        }
        aggregationPipeline.add(ctx -> {
            Document sort = new Document();
            for (Sort.Order order : accessor.getSort()) {
                sort.append(order.getProperty(), (Object)(order.isAscending() ? 1 : -1));
            }
            return ctx.getMappedObject(new Document("$sort", (Object)sort), targetType);
        });
    }

    static void appendLimitAndOffsetIfPresent(AggregationPipeline aggregationPipeline, ConvertingParameterAccessor accessor) {
        AggregationUtils.appendLimitAndOffsetIfPresent(aggregationPipeline, accessor, LongUnaryOperator.identity(), IntUnaryOperator.identity());
    }

    static void appendLimitAndOffsetIfPresent(AggregationPipeline aggregationPipeline, ConvertingParameterAccessor accessor, LongUnaryOperator offsetOperator, IntUnaryOperator limitOperator) {
        Pageable pageable = accessor.getPageable();
        if (pageable.isUnpaged()) {
            return;
        }
        if (pageable.getOffset() > 0L) {
            aggregationPipeline.add(Aggregation.skip(offsetOperator.applyAsLong(pageable.getOffset())));
        }
        aggregationPipeline.add(Aggregation.limit(limitOperator.applyAsInt(pageable.getPageSize())));
    }

    static <T> @Nullable T extractSimpleTypeResult(@Nullable Document source, Class<T> targetType, MongoConverter converter) {
        if (ObjectUtils.isEmpty((Object)source)) {
            return null;
        }
        if (source.size() == 1) {
            return AggregationUtils.getPotentiallyConvertedSimpleTypeValue(converter, source.values().iterator().next(), targetType);
        }
        Document intermediate = new Document((Map)source);
        intermediate.remove((Object)FieldName.ID.name());
        if (intermediate.size() == 1) {
            return AggregationUtils.getPotentiallyConvertedSimpleTypeValue(converter, intermediate.values().iterator().next(), targetType);
        }
        for (Map.Entry entry : intermediate.entrySet()) {
            if (entry == null || !ClassUtils.isAssignable(targetType, entry.getValue().getClass())) continue;
            return targetType.cast(entry.getValue());
        }
        throw new IllegalArgumentException(String.format("o_O no entry of type %s found in %s.", targetType.getSimpleName(), source.toJson()));
    }

    private static <T> @Nullable T getPotentiallyConvertedSimpleTypeValue(MongoConverter converter, @Nullable Object value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        if (ClassUtils.isAssignableValue(targetType, (Object)value)) {
            return (T)value;
        }
        return (T)converter.getConversionService().convert(value, targetType);
    }

    static interface AggregationCallback<T> {
        public @Nullable T doAggregate(TypedAggregation<?> var1, Class<?> var2, Class<?> var3, Class<?> var4, boolean var5, boolean var6);
    }
}

