/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.bson.BsonRegularExpression;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Polygon;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.Sphere;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.MongoRegexCreator;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.util.Lazy;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ConcurrentLruCache;
import org.springframework.util.ObjectUtils;

public class MongoAotRepositoryFragmentSupport {
    private static final ParameterBindingDocumentCodec CODEC = new ParameterBindingDocumentCodec();
    private final RepositoryMetadata repositoryMetadata;
    private final MongoOperations mongoOperations;
    private final MongoConverter mongoConverter;
    private final ProjectionFactory projectionFactory;
    private final ValueExpressionDelegate valueExpressions;
    private final Lazy<ConcurrentLruCache<String, ValueExpression>> expressions;
    private final Lazy<ConcurrentLruCache<Method, MongoParameters>> mongoParameters;
    private final Lazy<ConcurrentLruCache<Method, ValueEvaluationContextProvider>> contextProviders;

    protected MongoAotRepositoryFragmentSupport(MongoOperations mongoOperations, RepositoryFactoryBeanSupport.FragmentCreationContext context) {
        this(mongoOperations, context.getRepositoryMetadata(), context.getValueExpressionDelegate(), context.getProjectionFactory());
    }

    protected MongoAotRepositoryFragmentSupport(MongoOperations mongoOperations, RepositoryMetadata repositoryMetadata, ValueExpressionDelegate valueExpressions, ProjectionFactory projectionFactory) {
        this.mongoOperations = mongoOperations;
        this.mongoConverter = mongoOperations.getConverter();
        this.repositoryMetadata = repositoryMetadata;
        this.projectionFactory = projectionFactory;
        this.valueExpressions = valueExpressions;
        this.expressions = Lazy.of(() -> new ConcurrentLruCache(32, arg_0 -> ((ValueExpressionDelegate)valueExpressions).parse(arg_0)));
        this.mongoParameters = Lazy.of(() -> new ConcurrentLruCache(32, it -> new MongoParameters(ParametersSource.of((RepositoryMetadata)repositoryMetadata, (Method)it))));
        this.contextProviders = Lazy.of(() -> new ConcurrentLruCache(32, it -> valueExpressions.createValueContextProvider((Parameters)((ConcurrentLruCache)this.mongoParameters.get()).get(it))));
    }

    protected Document parse(String json) {
        return CODEC.decode(json, new Object[0]);
    }

    protected Document bindParameters(final Method method, String source, final Object ... args) {
        MongoAotRepositoryFragmentSupport.expandGeoShapes(args);
        MongoParameters mongoParameters = (MongoParameters)((Object)((ConcurrentLruCache)this.mongoParameters.get()).get((Object)method));
        MongoParametersParameterAccessor parametersParameterAccessor = new MongoParametersParameterAccessor(mongoParameters, args);
        ParameterBindingContext bindingContext = new ParameterBindingContext(arg_0 -> ((MongoParametersParameterAccessor)parametersParameterAccessor).getBindableValue(arg_0), new ValueExpressionEvaluator(){
            final /* synthetic */ MongoAotRepositoryFragmentSupport this$0;
            {
                this.this$0 = this$0;
            }

            public <T> @Nullable T evaluate(String expression) {
                return (T)this.this$0.evaluate(method, expression, args);
            }
        });
        return CODEC.decode(source, bindingContext);
    }

    protected @Nullable Object evaluate(Method method, String source, Object ... args) {
        MongoAotRepositoryFragmentSupport.expandGeoShapes(args);
        ValueExpression expression = (ValueExpression)((ConcurrentLruCache)this.expressions.get()).get((Object)source);
        ValueEvaluationContextProvider contextProvider = (ValueEvaluationContextProvider)((ConcurrentLruCache)this.contextProviders.get()).get((Object)method);
        return expression.evaluate(contextProvider.getEvaluationContext((Object)args, expression.getExpressionDependencies()));
    }

    private static void expandGeoShapes(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof GeoJson) continue;
            Object object = args[i];
            if (object instanceof Circle) {
                Circle c = (Circle)object;
                args[i] = List.of(List.of(Double.valueOf(c.getCenter().getX()), Double.valueOf(c.getCenter().getY())), Double.valueOf(c.getRadius().getNormalizedValue()));
                continue;
            }
            object = args[i];
            if (object instanceof Sphere) {
                Sphere s = (Sphere)object;
                args[i] = List.of(List.of(Double.valueOf(s.getCenter().getX()), Double.valueOf(s.getCenter().getY())), Double.valueOf(s.getRadius().getNormalizedValue()));
                continue;
            }
            object = args[i];
            if (object instanceof Box) {
                Box b = (Box)object;
                args[i] = List.of(List.of(Double.valueOf(b.getFirst().getX()), Double.valueOf(b.getFirst().getY())), List.of(Double.valueOf(b.getSecond().getX()), Double.valueOf(b.getSecond().getY())));
                continue;
            }
            object = args[i];
            if (!(object instanceof Polygon)) continue;
            Polygon p = (Polygon)object;
            args[i] = p.getPoints().stream().map(it -> List.of(Double.valueOf(it.getX()), Double.valueOf(it.getY()))).toList();
        }
    }

    protected Consumer<Criteria> scoreBetween(Range.Bound<? extends Score> lower, Range.Bound<? extends Score> upper) {
        return criteria -> {
            double value;
            if (lower.isBounded()) {
                value = ((Score)lower.getValue().get()).getValue();
                if (lower.isInclusive()) {
                    criteria.gte(value);
                } else {
                    criteria.gt(value);
                }
            }
            if (upper.isBounded()) {
                value = ((Score)upper.getValue().get()).getValue();
                if (upper.isInclusive()) {
                    criteria.lte(value);
                } else {
                    criteria.lt(value);
                }
            }
        };
    }

    protected ScoringFunction scoringFunction(@Nullable Range<? extends Score> scoreRange) {
        if (scoreRange != null) {
            if (scoreRange.getUpperBound().isBounded()) {
                return ((Score)scoreRange.getUpperBound().getValue().get()).getFunction();
            }
            if (scoreRange.getLowerBound().isBounded()) {
                return ((Score)scoreRange.getLowerBound().getValue().get()).getFunction();
            }
        }
        return ScoringFunction.unspecified();
    }

    protected Collation collationOf(@Nullable Object source) {
        if (source == null) {
            return Collation.simple();
        }
        if (source instanceof CharSequence) {
            return Collation.parse(source.toString());
        }
        if (source instanceof Locale) {
            Locale locale = (Locale)source;
            return Collation.of(locale);
        }
        if (source instanceof Document) {
            Document document = (Document)source;
            return Collation.from(document);
        }
        if (source instanceof Collation) {
            Collation collation = (Collation)source;
            return collation;
        }
        throw new IllegalArgumentException("Unsupported collation source [%s]".formatted(ObjectUtils.nullSafeClassName((Object)source)));
    }

    protected Object toRegex(Object source) {
        return this.toRegex(source, null);
    }

    protected Object toRegex(Object source, @Nullable String options) {
        if (source instanceof String) {
            String sv = (String)source;
            return new BsonRegularExpression(MongoRegexCreator.INSTANCE.toRegularExpression(sv, MongoRegexCreator.MatchMode.LIKE), options);
        }
        if (source instanceof Pattern) {
            Pattern pattern = (Pattern)source;
            return pattern;
        }
        if (source instanceof Collection) {
            Collection collection = (Collection)source;
            return collection.stream().map(it -> this.toRegex(it, options)).toList();
        }
        if (ObjectUtils.isArray((Object)source)) {
            return this.toRegex(List.of(source), options);
        }
        return source;
    }

    protected BasicQuery createQuery(Method method, String queryString, Object ... parameters) {
        Document queryDocument = this.bindParameters(method, queryString, parameters);
        return new BasicQuery(queryDocument);
    }

    protected AggregationPipeline createPipeline(List<Object> rawStages) {
        if (rawStages.isEmpty()) {
            return new AggregationPipeline(List.of());
        }
        int size = rawStages.size();
        ArrayList<AggregationOperation> stages = new ArrayList<AggregationOperation>(size);
        Object firstElement = CollectionUtils.firstElement(rawStages);
        stages.add(MongoAotRepositoryFragmentSupport.rawToAggregationOperation(firstElement, true));
        if (size == 1) {
            return new AggregationPipeline(stages);
        }
        for (int i = 1; i < size; ++i) {
            stages.add(MongoAotRepositoryFragmentSupport.rawToAggregationOperation(rawStages.get(i), false));
        }
        return new AggregationPipeline(stages);
    }

    private static AggregationOperation rawToAggregationOperation(Object rawStage, boolean requiresMapping) {
        if (rawStage instanceof Document) {
            Document stageDocument = (Document)rawStage;
            if (requiresMapping) {
                return ctx -> ctx.getMappedObject(stageDocument);
            }
            return ctx -> stageDocument;
        }
        if (rawStage instanceof AggregationOperation) {
            AggregationOperation aggregationOperation = (AggregationOperation)rawStage;
            return aggregationOperation;
        }
        throw new RuntimeException("%s cannot be converted to AggregationOperation".formatted(rawStage.getClass()));
    }

    protected List<Object> convertSimpleRawResults(Class<?> targetType, List<Document> rawResults) {
        ArrayList<Object> list = new ArrayList<Object>(rawResults.size());
        for (Document it : rawResults) {
            list.add(MongoAotRepositoryFragmentSupport.extractSimpleTypeResult(it, targetType, this.mongoConverter));
        }
        return list;
    }

    protected @Nullable Object convertSimpleRawResult(Class<?> targetType, Document rawResult) {
        return MongoAotRepositoryFragmentSupport.extractSimpleTypeResult(rawResult, targetType, this.mongoConverter);
    }

    private static <T> @Nullable T extractSimpleTypeResult(@Nullable Document source, Class<T> targetType, MongoConverter converter) {
        if (ObjectUtils.isEmpty((Object)source)) {
            return null;
        }
        if (source.size() == 1) {
            return MongoAotRepositoryFragmentSupport.getPotentiallyConvertedSimpleTypeValue(converter, source.values().iterator().next(), targetType);
        }
        Document intermediate = new Document((Map)source);
        intermediate.remove((Object)FieldName.ID.name());
        if (intermediate.size() == 1) {
            return MongoAotRepositoryFragmentSupport.getPotentiallyConvertedSimpleTypeValue(converter, intermediate.values().iterator().next(), targetType);
        }
        for (Map.Entry entry : intermediate.entrySet()) {
            if (entry == null || !ClassUtils.isAssignable(targetType, entry.getValue().getClass())) continue;
            return targetType.cast(entry.getValue());
        }
        throw new IllegalArgumentException(String.format("o_O no entry of type %s found in %s.", targetType.getSimpleName(), source.toJson()));
    }

    private static <T> @Nullable T getPotentiallyConvertedSimpleTypeValue(MongoConverter converter, @Nullable Object value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        if (ClassUtils.isAssignableValue(targetType, (Object)value)) {
            return (T)value;
        }
        return (T)converter.getConversionService().convert(value, targetType);
    }
}

