/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.bson.Document;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.repository.Hint;
import org.springframework.data.mongodb.repository.ReadPreference;
import org.springframework.data.mongodb.repository.aot.AggregationInteraction;
import org.springframework.data.mongodb.repository.aot.MongoCodeBlocks;
import org.springframework.data.mongodb.repository.aot.Snippet;
import org.springframework.data.mongodb.repository.aot.VariableSnippet;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class AggregationBlocks {
    AggregationBlocks() {
    }

    private static Class<?> getOutputType(SimpleTypeHolder simpleTypeHolder, MongoQueryMethod queryMethod) {
        Class outputType = queryMethod.getReturnedObjectType();
        if (simpleTypeHolder.isSimpleType(outputType)) {
            return Document.class;
        }
        if (ClassUtils.isAssignable(AggregationResults.class, (Class)outputType) && queryMethod.getReturnType().getComponentType() != null) {
            return queryMethod.getReturnType().getComponentType().getType();
        }
        return outputType;
    }

    @NullUnmarked
    static class AggregationCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final SimpleTypeHolder simpleTypeHolder;
        private final MongoQueryMethod queryMethod;
        private final String parameterNames;
        private AggregationInteraction source;
        private String aggregationVariableName;
        private boolean pipelineOnly;

        AggregationCodeBlockBuilder(AotQueryMethodGenerationContext context, SimpleTypeHolder simpleTypeHolder, MongoQueryMethod queryMethod) {
            this.context = context;
            this.simpleTypeHolder = simpleTypeHolder;
            this.queryMethod = queryMethod;
            this.parameterNames = StringUtils.collectionToDelimitedString((Collection)context.getAllParameterNames(), (String)", ");
        }

        AggregationCodeBlockBuilder stages(AggregationInteraction aggregation) {
            this.source = aggregation;
            return this;
        }

        AggregationCodeBlockBuilder usingAggregationVariableName(String aggregationVariableName) {
            this.aggregationVariableName = aggregationVariableName;
            return this;
        }

        AggregationCodeBlockBuilder pipelineOnly(boolean pipelineOnly) {
            this.pipelineOnly = pipelineOnly;
            return this;
        }

        CodeBlock build() {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("\n", new Object[0]);
            String pipelineName = this.context.localVariable(this.aggregationVariableName + (this.pipelineOnly ? "" : "Pipeline"));
            builder.add(this.pipeline(pipelineName));
            if (!this.pipelineOnly) {
                Class domainType = this.context.getRepositoryInformation().getDomainType();
                Snippet.declare(builder).variable(ResolvableType.forClassWithGenerics(TypedAggregation.class, (Class[])new Class[]{domainType}), this.aggregationVariableName).as("$T.newAggregation($T.class, $L.getOperations())", Aggregation.class, domainType, pipelineName);
                builder.add(this.aggregationOptions(this.aggregationVariableName));
            }
            return builder.build();
        }

        private CodeBlock pipeline(String pipelineVariableName) {
            String sortParameter = this.context.getSortParameterName();
            String limitParameter = this.context.getLimitParameterName();
            String pageableParameter = this.context.getPageableParameterName();
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add(this.aggregationStages(this.context.localVariable("stages"), this.source.stages()));
            if (StringUtils.hasText((String)sortParameter)) {
                Class<?> outputType = AggregationBlocks.getOutputType(this.simpleTypeHolder, this.queryMethod);
                builder.add(this.sortingStage(sortParameter, outputType));
            }
            if (StringUtils.hasText((String)limitParameter)) {
                builder.add(this.limitingStage(limitParameter));
            }
            if (StringUtils.hasText((String)pageableParameter)) {
                builder.add(this.pagingStage(pageableParameter, this.queryMethod.isSliceQuery()));
            }
            builder.addStatement("$T $L = createPipeline($L)", new Object[]{AggregationPipeline.class, pipelineVariableName, this.context.localVariable("stages")});
            return builder.build();
        }

        private CodeBlock aggregationOptions(String aggregationVariableName) {
            MergedAnnotation readPreferenceAnnotation;
            String readPreference;
            MergedAnnotation hintAnnotation;
            String hint;
            CodeBlock.Builder builder = CodeBlock.builder();
            ArrayList<CodeBlock> options = new ArrayList<CodeBlock>(5);
            if (ReflectionUtils.isVoid((Class)this.queryMethod.getReturnedObjectType())) {
                options.add(CodeBlock.of((String)".skipOutput()", (Object[])new Object[0]));
            }
            String string = hint = (hintAnnotation = this.context.getAnnotation(Hint.class)).isPresent() ? hintAnnotation.getString("value") : null;
            if (StringUtils.hasText((String)hint)) {
                options.add(CodeBlock.of((String)".hint($S)", (Object[])new Object[]{hint}));
            }
            String string2 = readPreference = (readPreferenceAnnotation = this.context.getAnnotation(ReadPreference.class)).isPresent() ? readPreferenceAnnotation.getString("value") : null;
            if (StringUtils.hasText((String)readPreference)) {
                options.add(CodeBlock.of((String)".readPreference($T.valueOf($S))", (Object[])new Object[]{com.mongodb.ReadPreference.class, readPreference}));
            }
            if (this.queryMethod.hasAnnotatedCollation()) {
                options.add(CodeBlock.of((String)".collation($T.parse($S))", (Object[])new Object[]{Collation.class, this.queryMethod.getAnnotatedCollation()}));
            }
            if (!options.isEmpty()) {
                CodeBlock.Builder optionsBuilder = CodeBlock.builder();
                optionsBuilder.add("$1T $2L = $1T.builder()\n", new Object[]{AggregationOptions.class, this.context.localVariable("aggregationOptions")});
                optionsBuilder.indent();
                for (CodeBlock optionBlock : options) {
                    optionsBuilder.add(optionBlock);
                    optionsBuilder.add("\n", new Object[0]);
                }
                optionsBuilder.add(".build();\n", new Object[0]);
                optionsBuilder.unindent();
                builder.add(optionsBuilder.build());
                builder.addStatement("$1L = $1L.withOptions($2L)", new Object[]{aggregationVariableName, this.context.localVariable("aggregationOptions")});
            }
            return builder.build();
        }

        private CodeBlock aggregationStages(String stageListVariableName, Collection<String> stages) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.addStatement("$T<$T> $L = new $T($L)", new Object[]{List.class, Object.class, stageListVariableName, ArrayList.class, stages.size()});
            int stageCounter = 0;
            for (String stage : stages) {
                VariableSnippet stageSnippet = Snippet.declare(builder).variable(Document.class, this.context.localVariable("stage_%s".formatted(stageCounter))).of(MongoCodeBlocks.asDocument(this.context.getExpressionMarker(), stage, this.parameterNames));
                builder.addStatement("$L.add($L)", new Object[]{stageListVariableName, stageSnippet.getVariableName()});
                ++stageCounter;
            }
            return builder.build();
        }

        private CodeBlock sortingStage(String sortProvider, Class<?> outputType) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.beginControlFlow("if ($L.isSorted())", new Object[]{sortProvider});
            builder.addStatement("$1T $2L = new $1T()", new Object[]{Document.class, this.context.localVariable("sortDocument")});
            builder.beginControlFlow("for ($T $L : $L)", new Object[]{Sort.Order.class, this.context.localVariable("order"), sortProvider});
            builder.addStatement("$1L.append($2L.getProperty(), $2L.isAscending() ? 1 : -1);", new Object[]{this.context.localVariable("sortDocument"), this.context.localVariable("order")});
            builder.endControlFlow();
            if (outputType == Document.class || this.simpleTypeHolder.isSimpleType(outputType) || ClassUtils.isAssignable((Class)this.context.getRepositoryInformation().getDomainType(), outputType)) {
                builder.addStatement("$L.add(new $T($S, $L))", new Object[]{this.context.localVariable("stages"), Document.class, "$sort", this.context.localVariable("sortDocument")});
            } else {
                builder.addStatement("$L.add(($T) _ctx -> new $T($S, _ctx.getMappedObject($L, $T.class)))", new Object[]{this.context.localVariable("stages"), AggregationOperation.class, Document.class, "$sort", this.context.localVariable("sortDocument"), outputType});
            }
            builder.endControlFlow();
            return builder.build();
        }

        private CodeBlock pagingStage(String pageableProvider, boolean slice) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add(this.sortingStage(pageableProvider + ".getSort()", AggregationBlocks.getOutputType(this.simpleTypeHolder, this.queryMethod)));
            builder.beginControlFlow("if ($L.isPaged())", new Object[]{pageableProvider});
            builder.beginControlFlow("if ($L.getOffset() > 0)", new Object[]{pageableProvider});
            builder.addStatement("$L.add($T.skip($L.getOffset()))", new Object[]{this.context.localVariable("stages"), Aggregation.class, pageableProvider});
            builder.endControlFlow();
            if (slice) {
                builder.addStatement("$L.add($T.limit($L.getPageSize() + 1))", new Object[]{this.context.localVariable("stages"), Aggregation.class, pageableProvider});
            } else {
                builder.addStatement("$L.add($T.limit($L.getPageSize()))", new Object[]{this.context.localVariable("stages"), Aggregation.class, pageableProvider});
            }
            builder.endControlFlow();
            return builder.build();
        }

        private CodeBlock limitingStage(String limitProvider) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.beginControlFlow("if ($L.isLimited())", new Object[]{limitProvider});
            builder.addStatement("$L.add($T.limit($L.max()))", new Object[]{this.context.localVariable("stages"), Aggregation.class, limitProvider});
            builder.endControlFlow();
            return builder.build();
        }
    }

    @NullUnmarked
    static class AggregationExecutionCodeBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final SimpleTypeHolder simpleTypeHolder;
        private final MongoQueryMethod queryMethod;
        private String aggregationVariableName;

        AggregationExecutionCodeBlockBuilder(AotQueryMethodGenerationContext context, SimpleTypeHolder simpleTypeHolder, MongoQueryMethod queryMethod) {
            this.context = context;
            this.simpleTypeHolder = simpleTypeHolder;
            this.queryMethod = queryMethod;
        }

        AggregationExecutionCodeBlockBuilder referencing(String aggregationVariableName) {
            this.aggregationVariableName = aggregationVariableName;
            return this;
        }

        CodeBlock build() {
            String mongoOpsRef = this.context.fieldNameOf(MongoOperations.class);
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("\n", new Object[0]);
            Class<?> outputType = AggregationBlocks.getOutputType(this.simpleTypeHolder, this.queryMethod);
            if (ReflectionUtils.isVoid((Class)this.queryMethod.getReturnedObjectType())) {
                builder.addStatement("$L.aggregate($L, $T.class)", new Object[]{mongoOpsRef, this.aggregationVariableName, outputType});
                return builder.build();
            }
            if (ClassUtils.isAssignable(AggregationResults.class, this.context.getMethod().getReturnType())) {
                builder.addStatement("return $L.aggregate($L, $T.class)", new Object[]{mongoOpsRef, this.aggregationVariableName, outputType});
                return builder.build();
            }
            if (outputType == Document.class) {
                Class returnType = ClassUtils.resolvePrimitiveIfNecessary((Class)this.queryMethod.getReturnedObjectType());
                if (this.queryMethod.isStreamQuery()) {
                    VariableSnippet results = Snippet.declare(builder).variable(ResolvableType.forClassWithGenerics(Stream.class, (Class[])new Class[]{Document.class}), this.context.localVariable("results")).as("$L.aggregateStream($L, $T.class)", mongoOpsRef, this.aggregationVariableName, outputType);
                    builder.addStatement("return $1L.map(it -> ($2T) convertSimpleRawResult($2T.class, it))", new Object[]{results.getVariableName(), returnType});
                } else {
                    VariableSnippet results = Snippet.declare(builder).variable(AggregationResults.class, this.context.localVariable("results")).as("$L.aggregate($L, $T.class)", mongoOpsRef, this.aggregationVariableName, outputType);
                    if (!this.queryMethod.isCollectionQuery()) {
                        builder.addStatement("return $1T.<$2T>firstElement(convertSimpleRawResults($2T.class, $3L.getMappedResults()))", new Object[]{CollectionUtils.class, returnType, results.getVariableName()});
                    } else {
                        builder.addStatement("return convertSimpleRawResults($T.class, $L.getMappedResults())", new Object[]{returnType, results.getVariableName()});
                    }
                }
            } else if (this.queryMethod.isSliceQuery()) {
                VariableSnippet results = Snippet.declare(builder).variable(AggregationResults.class, this.context.localVariable("results")).as("$L.aggregate($L, $T.class)", mongoOpsRef, this.aggregationVariableName, outputType);
                VariableSnippet hasNext = Snippet.declare(builder).variable("hasNext").as("$L.getMappedResults().size() > $L.getPageSize()", results.getVariableName(), this.context.getPageableParameterName());
                builder.addStatement("return new $1T<>($2L ? $3L.getMappedResults().subList(0, $4L.getPageSize()) : $3L.getMappedResults(), $4L, $2L)", new Object[]{SliceImpl.class, hasNext.getVariableName(), results.getVariableName(), this.context.getPageableParameterName()});
            } else if (this.queryMethod.isStreamQuery()) {
                builder.addStatement("return $L.aggregateStream($L, $T.class)", new Object[]{mongoOpsRef, this.aggregationVariableName, outputType});
            } else {
                builder.addStatement("return $L.aggregate($L, $T.class).getMappedResults()", new Object[]{mongoOpsRef, this.aggregationVariableName, outputType});
            }
            return builder.build();
        }
    }
}

