/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.observability;

import io.micrometer.common.KeyValue;
import io.micrometer.common.docs.KeyName;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.util.StringUtils;

record MongoKeyName<C>(String name, boolean required, Function<C, @Nullable Object> valueFunction) implements KeyName
{
    static <C> MongoKeyName<C> required(String name, Function<C, @Nullable Object> valueFunction) {
        return MongoKeyName.required(name, valueFunction, Objects::nonNull);
    }

    public static <C> MongoKeyName<C> requiredString(String name, Function<C, @Nullable String> valueFunction) {
        return MongoKeyName.required(name, valueFunction, StringUtils::hasText);
    }

    public static <C, V> MongoKeyName<C> required(String name, Function<C, V> valueFunction, Predicate<V> hasValue) {
        return new MongoKeyName<Object>(name, true, c -> {
            Object value = valueFunction.apply(c);
            return hasValue.test(value) ? value : null;
        });
    }

    public static MongoKeyValue just(String name, String value) {
        return new MongoKeyName<Object>(name, false, it -> value).withValue(value);
    }

    public MongoKeyValue withValue(String value) {
        return new MongoKeyValue(this, value);
    }

    public MongoKeyValue valueOf(@Nullable C context) {
        Object value = context != null ? this.valueFunction.apply(context) : null;
        return new MongoKeyValue(this, value == null ? "none" : value.toString());
    }

    public MongoKeyValue absent() {
        return new MongoKeyValue(this, "none");
    }

    public boolean isRequired() {
        return this.required;
    }

    public String asString() {
        return this.name;
    }

    @Override
    public String toString() {
        return "Key: " + this.asString();
    }

    static class MongoKeyValue
    implements KeyName,
    KeyValue {
        private final KeyName keyName;
        private final String value;

        MongoKeyValue(KeyName keyName, String value) {
            this.keyName = keyName;
            this.value = value;
        }

        public String getKey() {
            return this.keyName.asString();
        }

        public String getValue() {
            return this.value;
        }

        public String asString() {
            return this.getKey();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

