/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.Collection;
import java.util.regex.Pattern;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.data.mongodb.repository.ReadPreference;
import org.springframework.data.mongodb.repository.aot.AggregationBlocks;
import org.springframework.data.mongodb.repository.aot.DeleteBlocks;
import org.springframework.data.mongodb.repository.aot.GeoBlocks;
import org.springframework.data.mongodb.repository.aot.QueryBlocks;
import org.springframework.data.mongodb.repository.aot.UpdateBlocks;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

class MongoCodeBlocks {
    private static final Pattern PARAMETER_BINDING_PATTERN = Pattern.compile("\\?(\\d+)");
    private static final Pattern EXPRESSION_BINDING_PATTERN = Pattern.compile("[\\?:][#$]\\{.*\\}");
    private static final Pattern VALUE_EXPRESSION_PATTERN = Pattern.compile("^#\\{.*}$");

    MongoCodeBlocks() {
    }

    static QueryBlocks.QueryCodeBlockBuilder queryBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new QueryBlocks.QueryCodeBlockBuilder(context, queryMethod);
    }

    static QueryBlocks.QueryExecutionCodeBlockBuilder queryExecutionBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new QueryBlocks.QueryExecutionCodeBlockBuilder(context, queryMethod);
    }

    static DeleteBlocks.DeleteExecutionCodeBlockBuilder deleteExecutionBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new DeleteBlocks.DeleteExecutionCodeBlockBuilder(context, queryMethod);
    }

    static UpdateBlocks.UpdateCodeBlockBuilder updateBlockBuilder(AotQueryMethodGenerationContext context) {
        return new UpdateBlocks.UpdateCodeBlockBuilder(context);
    }

    static UpdateBlocks.UpdateExecutionCodeBlockBuilder updateExecutionBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new UpdateBlocks.UpdateExecutionCodeBlockBuilder(context, queryMethod);
    }

    static AggregationBlocks.AggregationCodeBlockBuilder aggregationBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new AggregationBlocks.AggregationCodeBlockBuilder(context, queryMethod);
    }

    static AggregationBlocks.AggregationExecutionCodeBlockBuilder aggregationExecutionBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new AggregationBlocks.AggregationExecutionCodeBlockBuilder(context, queryMethod);
    }

    static GeoBlocks.GeoNearCodeBlockBuilder geoNearBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new GeoBlocks.GeoNearCodeBlockBuilder(context, queryMethod);
    }

    static GeoBlocks.GeoNearExecutionCodeBlockBuilder geoNearExecutionBlockBuilder(AotQueryMethodGenerationContext context) {
        return new GeoBlocks.GeoNearExecutionCodeBlockBuilder(context);
    }

    static CodeBlock asDocument(String source, String argNames) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (!StringUtils.hasText((String)source)) {
            builder.add("new $T()", new Object[]{Document.class});
        } else if (MongoCodeBlocks.containsPlaceholder(source)) {
            builder.add("bindParameters(ExpressionMarker.class.getEnclosingMethod(), $S$L);\n", new Object[]{source, argNames});
        } else {
            builder.add("parse($S)", new Object[]{source});
        }
        return builder.build();
    }

    static CodeBlock renderExpressionToDocument(@Nullable String source, String variableName, String argNames) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (!StringUtils.hasText((String)source)) {
            builder.addStatement("$1T $2L = new $1T()", new Object[]{Document.class, variableName});
        } else if (MongoCodeBlocks.containsPlaceholder(source)) {
            builder.add("$T $L = bindParameters(ExpressionMarker.class.getEnclosingMethod(), $S$L);\n", new Object[]{Document.class, variableName, source, argNames});
        } else {
            builder.addStatement("$1T $2L = parse($3S)", new Object[]{Document.class, variableName, source});
        }
        return builder.build();
    }

    static CodeBlock evaluateNumberPotentially(String value, Class<? extends Number> targetType, AotQueryMethodGenerationContext context) {
        try {
            Number number = NumberUtils.parseNumber((String)value, targetType);
            return CodeBlock.of((String)"$L", (Object[])new Object[]{number});
        }
        catch (IllegalArgumentException e) {
            Object parameterNames = StringUtils.collectionToDelimitedString((Collection)context.getAllParameterNames(), (String)", ");
            parameterNames = StringUtils.hasText((String)parameterNames) ? ", " + (String)parameterNames : "";
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("($T) evaluate(ExpressionMarker.class.getEnclosingMethod(), $S$L)", new Object[]{targetType, value, parameterNames});
            return builder.build();
        }
    }

    static boolean containsPlaceholder(String source) {
        return MongoCodeBlocks.containsIndexedPlaceholder(source) || MongoCodeBlocks.containsNamedPlaceholder(source);
    }

    static boolean containsExpression(String source) {
        return VALUE_EXPRESSION_PATTERN.matcher(source).find();
    }

    static boolean containsNamedPlaceholder(String source) {
        return EXPRESSION_BINDING_PATTERN.matcher(source).find();
    }

    static boolean containsIndexedPlaceholder(String source) {
        return PARAMETER_BINDING_PATTERN.matcher(source).find();
    }

    static void appendReadPreference(AotQueryMethodGenerationContext context, CodeBlock.Builder builder, String queryVariableName) {
        String readPreference;
        MergedAnnotation readPreferenceAnnotation = context.getAnnotation(ReadPreference.class);
        String string = readPreference = readPreferenceAnnotation.isPresent() ? readPreferenceAnnotation.getString("value") : null;
        if (StringUtils.hasText((String)readPreference)) {
            builder.addStatement("$L.withReadPreference($T.valueOf($S))", new Object[]{queryVariableName, com.mongodb.ReadPreference.class, readPreference});
        }
    }
}

