/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.mongodb.repository.aot.MongoInteraction;
import org.springframework.data.mongodb.repository.aot.StringQuery;
import org.springframework.data.repository.aot.generate.QueryMetadata;
import org.springframework.util.StringUtils;

class QueryInteraction
extends MongoInteraction
implements QueryMetadata {
    private final StringQuery query;
    private final MongoInteraction.InteractionType interactionType;

    QueryInteraction(StringQuery query, boolean count, boolean delete, boolean exists) {
        this.query = query;
        this.interactionType = count ? MongoInteraction.InteractionType.COUNT : (exists ? MongoInteraction.InteractionType.EXISTS : (delete ? MongoInteraction.InteractionType.DELETE : MongoInteraction.InteractionType.QUERY));
    }

    StringQuery getQuery() {
        return this.query;
    }

    QueryInteraction withSort(String sort) {
        this.query.sort(sort);
        return this;
    }

    QueryInteraction withFields(String fields) {
        this.query.fields(fields);
        return this;
    }

    @Override
    MongoInteraction.InteractionType getExecutionType() {
        return this.interactionType;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> serialized = new LinkedHashMap<String, Object>();
        serialized.put("filter", this.query.getQueryString());
        if (this.query.isSorted()) {
            serialized.put("sort", this.query.getSortString());
        }
        if (StringUtils.hasText((String)this.query.getFieldsString())) {
            serialized.put("fields", this.query.getFieldsString());
        }
        return serialized;
    }
}

