/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.AggregationUpdate;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.mongodb.repository.Update;
import org.springframework.data.mongodb.repository.aot.AggregationInteraction;
import org.springframework.data.mongodb.repository.aot.AggregationUpdateInteraction;
import org.springframework.data.mongodb.repository.aot.AotQueryCreator;
import org.springframework.data.mongodb.repository.aot.MongoAotRepositoryFragmentSupport;
import org.springframework.data.mongodb.repository.aot.MongoCodeBlocks;
import org.springframework.data.mongodb.repository.aot.QueryInteraction;
import org.springframework.data.mongodb.repository.aot.StringQuery;
import org.springframework.data.mongodb.repository.aot.StringUpdate;
import org.springframework.data.mongodb.repository.aot.UpdateInteraction;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.aot.generate.AotRepositoryClassBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.MethodContributor;
import org.springframework.data.repository.aot.generate.QueryMetadata;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MongoRepositoryContributor
extends RepositoryContributor {
    private static final Log logger = LogFactory.getLog(MongoRepositoryContributor.class);
    private final AotQueryCreator queryCreator = new AotQueryCreator();
    private final MongoMappingContext mappingContext = new MongoMappingContext();

    public MongoRepositoryContributor(AotRepositoryContext repositoryContext) {
        super(repositoryContext);
    }

    protected void customizeClass(AotRepositoryClassBuilder classBuilder) {
        classBuilder.customize(builder -> builder.superclass(TypeName.get(MongoAotRepositoryFragmentSupport.class)));
    }

    protected void customizeConstructor(AotRepositoryConstructorBuilder constructorBuilder) {
        constructorBuilder.addParameter("operations", TypeName.get(MongoOperations.class));
        constructorBuilder.addParameter("context", TypeName.get(RepositoryFactoryBeanSupport.FragmentCreationContext.class), false);
        constructorBuilder.customize(builder -> builder.addStatement("super(operations, context)", new Object[0]));
    }

    protected @Nullable MethodContributor<? extends QueryMethod> contributeQueryMethod(Method method) {
        MongoQueryMethod queryMethod = new MongoQueryMethod(method, (RepositoryMetadata)this.getRepositoryInformation(), this.getProjectionFactory(), (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)this.mappingContext);
        if (queryMethod.hasAnnotatedAggregation()) {
            AggregationInteraction aggregation = new AggregationInteraction(queryMethod.getAnnotatedAggregation());
            return MongoRepositoryContributor.aggregationMethodContributor(queryMethod, aggregation);
        }
        QueryInteraction query = this.createStringQuery(this.getRepositoryInformation(), queryMethod, (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Query.class), method.getParameterCount());
        if (queryMethod.hasAnnotatedQuery() && StringUtils.hasText((String)queryMethod.getAnnotatedQuery()) && Pattern.compile("[\\?:][#$]\\{.*\\}").matcher(queryMethod.getAnnotatedQuery()).find()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Skipping AOT generation for [%s]. SpEL expressions are not supported".formatted(method.getName()));
            }
            return MethodContributor.forQueryMethod((QueryMethod)queryMethod).metadataOnly((QueryMetadata)query);
        }
        if (MongoRepositoryContributor.backoff(queryMethod)) {
            return null;
        }
        if (query.isDelete()) {
            return MongoRepositoryContributor.deleteMethodContributor(queryMethod, query);
        }
        if (queryMethod.isModifyingQuery()) {
            int updateIndex = queryMethod.getParameters().getUpdateIndex();
            if (updateIndex != -1) {
                UpdateInteraction update = new UpdateInteraction(query, null, updateIndex);
                return MongoRepositoryContributor.updateMethodContributor(queryMethod, update);
            }
            Update updateSource = queryMethod.getUpdateSource();
            if (StringUtils.hasText((String)updateSource.value())) {
                UpdateInteraction update = new UpdateInteraction(query, new StringUpdate(updateSource.value()), null);
                return MongoRepositoryContributor.updateMethodContributor(queryMethod, update);
            }
            if (!ObjectUtils.isEmpty((Object[])updateSource.pipeline())) {
                AggregationUpdateInteraction update = new AggregationUpdateInteraction(query, updateSource.pipeline());
                return MongoRepositoryContributor.aggregationUpdateMethodContributor(queryMethod, update);
            }
        }
        return MongoRepositoryContributor.queryMethodContributor(queryMethod, query);
    }

    private QueryInteraction createStringQuery(RepositoryInformation repositoryInformation, MongoQueryMethod queryMethod, @Nullable Query queryAnnotation, int parameterCount) {
        QueryInteraction query;
        if (queryMethod.hasAnnotatedQuery() && queryAnnotation != null) {
            query = new QueryInteraction(new StringQuery(queryMethod.getAnnotatedQuery()), queryAnnotation.count(), queryAnnotation.delete(), queryAnnotation.exists());
        } else {
            PartTree partTree = new PartTree(queryMethod.getName(), repositoryInformation.getDomainType());
            query = new QueryInteraction(this.queryCreator.createQuery(partTree, parameterCount), partTree.isCountProjection(), partTree.isDelete(), partTree.isExistsProjection());
        }
        if (queryAnnotation != null && StringUtils.hasText((String)queryAnnotation.sort())) {
            query = query.withSort(queryAnnotation.sort());
        }
        if (queryAnnotation != null && StringUtils.hasText((String)queryAnnotation.fields())) {
            query = query.withFields(queryAnnotation.fields());
        }
        return query;
    }

    private static boolean backoff(MongoQueryMethod method) {
        boolean skip;
        boolean bl = skip = method.isGeoNearQuery() || method.isSearchQuery() || method.getName().toLowerCase(Locale.ROOT).contains("regex") || method.getReturnType().getType().isArray();
        if (skip && logger.isDebugEnabled()) {
            logger.debug((Object)"Skipping AOT generation for [%s]. Method is either returning an array or a geo-near, regex query".formatted(method.getName()));
        }
        return skip;
    }

    private static MethodContributor<MongoQueryMethod> aggregationMethodContributor(MongoQueryMethod queryMethod, AggregationInteraction aggregation) {
        return MethodContributor.forQueryMethod((QueryMethod)queryMethod).withMetadata((QueryMetadata)aggregation).contribute(context -> {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add(MongoCodeBlocks.aggregationBlockBuilder(context, queryMethod).stages(aggregation).usingAggregationVariableName("aggregation").build());
            builder.add(MongoCodeBlocks.aggregationExecutionBlockBuilder(context, queryMethod).referencing("aggregation").build());
            return builder.build();
        });
    }

    private static MethodContributor<MongoQueryMethod> updateMethodContributor(MongoQueryMethod queryMethod, UpdateInteraction update) {
        return MethodContributor.forQueryMethod((QueryMethod)queryMethod).withMetadata((QueryMetadata)update).contribute(context -> {
            String updateVariableName;
            CodeBlock.Builder builder = CodeBlock.builder();
            String filterVariableName = context.localVariable(update.name());
            builder.add(MongoCodeBlocks.queryBlockBuilder(context, queryMethod).filter(update.getFilter()).usingQueryVariableName(filterVariableName).build());
            if (update.hasUpdateDefinitionParameter()) {
                updateVariableName = context.getParameterName(update.getRequiredUpdateDefinitionParameter());
            } else {
                updateVariableName = context.localVariable("updateDefinition");
                builder.add(MongoCodeBlocks.updateBlockBuilder(context, queryMethod).update(update).usingUpdateVariableName(updateVariableName).build());
            }
            builder.add(MongoCodeBlocks.updateExecutionBlockBuilder(context, queryMethod).withFilter(filterVariableName).referencingUpdate(updateVariableName).build());
            return builder.build();
        });
    }

    private static MethodContributor<MongoQueryMethod> aggregationUpdateMethodContributor(MongoQueryMethod queryMethod, AggregationUpdateInteraction update) {
        return MethodContributor.forQueryMethod((QueryMethod)queryMethod).withMetadata((QueryMetadata)update).contribute(context -> {
            CodeBlock.Builder builder = CodeBlock.builder();
            String filterVariableName = context.localVariable(update.name());
            MongoCodeBlocks.QueryCodeBlockBuilder queryCodeBlockBuilder = MongoCodeBlocks.queryBlockBuilder(context, queryMethod).filter(update.getFilter());
            builder.add(queryCodeBlockBuilder.usingQueryVariableName(filterVariableName).build());
            String updateVariableName = "updateDefinition";
            builder.add(MongoCodeBlocks.aggregationBlockBuilder(context, queryMethod).stages(update).usingAggregationVariableName(updateVariableName).pipelineOnly(true).build());
            builder.addStatement("$T $L = $T.from($L.getOperations())", new Object[]{AggregationUpdate.class, context.localVariable("aggregationUpdate"), AggregationUpdate.class, updateVariableName});
            builder.add(MongoCodeBlocks.updateExecutionBlockBuilder(context, queryMethod).withFilter(filterVariableName).referencingUpdate(context.localVariable("aggregationUpdate")).build());
            return builder.build();
        });
    }

    private static MethodContributor<MongoQueryMethod> deleteMethodContributor(MongoQueryMethod queryMethod, QueryInteraction query) {
        return MethodContributor.forQueryMethod((QueryMethod)queryMethod).withMetadata((QueryMetadata)query).contribute(context -> {
            CodeBlock.Builder builder = CodeBlock.builder();
            MongoCodeBlocks.QueryCodeBlockBuilder queryCodeBlockBuilder = MongoCodeBlocks.queryBlockBuilder(context, queryMethod).filter(query);
            String queryVariableName = context.localVariable(query.name());
            builder.add(queryCodeBlockBuilder.usingQueryVariableName(queryVariableName).build());
            builder.add(MongoCodeBlocks.deleteExecutionBlockBuilder(context, queryMethod).referencing(queryVariableName).build());
            return builder.build();
        });
    }

    private static MethodContributor<MongoQueryMethod> queryMethodContributor(MongoQueryMethod queryMethod, QueryInteraction query) {
        return MethodContributor.forQueryMethod((QueryMethod)queryMethod).withMetadata((QueryMetadata)query).contribute(context -> {
            CodeBlock.Builder builder = CodeBlock.builder();
            MongoCodeBlocks.QueryCodeBlockBuilder queryCodeBlockBuilder = MongoCodeBlocks.queryBlockBuilder(context, queryMethod).filter(query);
            builder.add(queryCodeBlockBuilder.usingQueryVariableName(context.localVariable(query.name())).build());
            builder.add(MongoCodeBlocks.queryExecutionBlockBuilder(context, queryMethod).forQuery(query).build());
            return builder.build();
        });
    }
}

