/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.observability;

import com.mongodb.ConnectionString;
import com.mongodb.ServerAddress;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionId;
import com.mongodb.event.CommandStartedEvent;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import org.springframework.data.mongodb.observability.MongoHandlerContext;
import org.springframework.data.mongodb.observability.MongoHandlerObservationConvention;
import org.springframework.data.mongodb.observability.MongoObservation;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class DefaultMongoHandlerObservationConvention
implements MongoHandlerObservationConvention {
    DefaultMongoHandlerObservationConvention() {
    }

    public KeyValues getLowCardinalityKeyValues(MongoHandlerContext context) {
        KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{MongoObservation.LowCardinalityCommandKeyNames.DB_SYSTEM.withValue("mongodb"), MongoObservation.LowCardinalityCommandKeyNames.MONGODB_COMMAND.withValue(context.getCommandName())});
        ConnectionString connectionString = context.getConnectionString();
        if (connectionString != null) {
            keyValues = keyValues.and(new KeyValue[]{MongoObservation.LowCardinalityCommandKeyNames.DB_CONNECTION_STRING.withValue(connectionString.getConnectionString())});
            String user = connectionString.getUsername();
            if (!ObjectUtils.isEmpty((Object)user)) {
                keyValues = keyValues.and(new KeyValue[]{MongoObservation.LowCardinalityCommandKeyNames.DB_USER.withValue(user)});
            }
        }
        if (!ObjectUtils.isEmpty((Object)context.getDatabaseName())) {
            keyValues = keyValues.and(new KeyValue[]{MongoObservation.LowCardinalityCommandKeyNames.DB_NAME.withValue(context.getDatabaseName())});
        }
        if (!ObjectUtils.isEmpty((Object)context.getCollectionName())) {
            keyValues = keyValues.and(new KeyValue[]{MongoObservation.LowCardinalityCommandKeyNames.MONGODB_COLLECTION.withValue(context.getCollectionName())});
        }
        if (context.getCommandStartedEvent() == null) {
            throw new IllegalStateException("not command started event present");
        }
        ConnectionDescription connectionDescription = context.getCommandStartedEvent().getConnectionDescription();
        if (connectionDescription != null) {
            ConnectionId connectionId;
            ServerAddress serverAddress = connectionDescription.getServerAddress();
            if (serverAddress != null) {
                keyValues = keyValues.and(new KeyValue[]{MongoObservation.LowCardinalityCommandKeyNames.NET_TRANSPORT.withValue("IP.TCP"), MongoObservation.LowCardinalityCommandKeyNames.NET_PEER_NAME.withValue(serverAddress.getHost()), MongoObservation.LowCardinalityCommandKeyNames.NET_PEER_PORT.withValue("" + serverAddress.getPort())});
            }
            if ((connectionId = connectionDescription.getConnectionId()) != null) {
                keyValues = keyValues.and(new KeyValue[]{MongoObservation.LowCardinalityCommandKeyNames.MONGODB_CLUSTER_ID.withValue(connectionId.getServerId().getClusterId().getValue())});
            }
        }
        return keyValues;
    }

    public KeyValues getHighCardinalityKeyValues(MongoHandlerContext context) {
        return KeyValues.empty();
    }

    public String getContextualName(MongoHandlerContext context) {
        String collectionName = context.getCollectionName();
        CommandStartedEvent commandStartedEvent = context.getCommandStartedEvent();
        Assert.notNull((Object)commandStartedEvent, (String)"CommandStartedEvent must not be null");
        if (ObjectUtils.isEmpty((Object)collectionName)) {
            return commandStartedEvent.getCommandName();
        }
        return collectionName + "." + commandStartedEvent.getCommandName();
    }
}

