/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.regex.Pattern;
import org.bson.BsonRegularExpression;
import org.jspecify.annotations.Nullable;

public enum MongoRegexCreator {
    INSTANCE;

    private static final Pattern PUNCTATION_PATTERN;

    public @Nullable String toRegularExpression(@Nullable String source, @Nullable MatchMode matcherType) {
        if (matcherType == null || source == null) {
            return source;
        }
        String regex = this.prepareAndEscapeStringBeforeApplyingLikeRegex(source, matcherType);
        return switch (matcherType.ordinal()) {
            case 2 -> String.format("^%s", regex);
            case 3 -> String.format("%s$", regex);
            case 4 -> String.format(".*%s.*", regex);
            case 1 -> String.format("^%s$", regex);
            default -> regex;
        };
    }

    @Deprecated(since="4.1.1", forRemoval=true)
    public Object toCaseInsensitiveMatch(Object source) {
        Object object;
        if (source instanceof String) {
            String stringValue = (String)source;
            object = new BsonRegularExpression(Pattern.quote(stringValue), "i");
        } else {
            object = source;
        }
        return object;
    }

    private String prepareAndEscapeStringBeforeApplyingLikeRegex(String source, MatchMode matcherType) {
        boolean trailingWildcard;
        if (MatchMode.REGEX == matcherType) {
            return source;
        }
        if (MatchMode.LIKE != matcherType) {
            return PUNCTATION_PATTERN.matcher(source).find() ? Pattern.quote(source) : source;
        }
        if (source.equals("*")) {
            return ".*";
        }
        StringBuilder sb = new StringBuilder();
        boolean leadingWildcard = source.startsWith("*");
        String valueToUse = source.substring(leadingWildcard ? 1 : 0, (trailingWildcard = source.endsWith("*")) ? source.length() - 1 : source.length());
        if (PUNCTATION_PATTERN.matcher(valueToUse).find()) {
            valueToUse = Pattern.quote(valueToUse);
        }
        if (leadingWildcard) {
            sb.append(".*");
        }
        sb.append(valueToUse);
        if (trailingWildcard) {
            sb.append(".*");
        }
        return sb.toString();
    }

    static {
        PUNCTATION_PATTERN = Pattern.compile("\\p{Punct}");
    }

    public static enum MatchMode {
        DEFAULT,
        EXACT,
        STARTING_WITH,
        ENDING_WITH,
        CONTAINING,
        REGEX,
        LIKE;

    }
}

