/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.MongoClientSettings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bson.BinaryVector;
import org.bson.BsonArray;
import org.bson.BsonDouble;
import org.bson.BsonReader;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.convert.ConverterBuilder;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.domain.Vector;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.mapping.MongoVector;
import org.springframework.data.mongodb.core.query.Term;
import org.springframework.data.mongodb.core.script.NamedMongoScript;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

abstract class MongoConverters {
    private MongoConverters() {
    }

    static Collection<Object> getConvertersToRegister() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add((Object)BigDecimalToDecimal128Converter.INSTANCE);
        converters.add((Object)Decimal128ToBigDecimalConverter.INSTANCE);
        converters.add((Object)BigIntegerToDecimal128Converter.INSTANCE);
        converters.add((Object)URLToStringConverter.INSTANCE);
        converters.add((Object)StringToURLConverter.INSTANCE);
        converters.add((Object)DocumentToStringConverter.INSTANCE);
        converters.add((Object)TermToStringConverter.INSTANCE);
        converters.add((Object)NamedMongoScriptToDocumentConverter.INSTANCE);
        converters.add((Object)DocumentToNamedMongoScriptConverter.INSTANCE);
        converters.add((Object)CurrencyToStringConverter.INSTANCE);
        converters.add((Object)StringToCurrencyConverter.INSTANCE);
        converters.add((Object)AtomicIntegerToIntegerConverter.INSTANCE);
        converters.add((Object)AtomicLongToLongConverter.INSTANCE);
        converters.add((Object)LongToAtomicLongConverter.INSTANCE);
        converters.add((Object)IntegerToAtomicIntegerConverter.INSTANCE);
        converters.add((Object)BinaryToByteArrayConverter.INSTANCE);
        converters.add((Object)BsonTimestampToInstantConverter.INSTANCE);
        converters.add((Object)NumberToNumberConverterFactory.INSTANCE);
        converters.add((Object)VectorToBsonArrayConverter.INSTANCE);
        converters.add((Object)ListToVectorConverter.INSTANCE);
        converters.add((Object)BinaryVectorToMongoVectorConverter.INSTANCE);
        converters.add(ConverterBuilder.reading(BsonUndefined.class, Object.class, it -> null));
        converters.add(ConverterBuilder.reading(String.class, URI.class, URI::create).andWriting(URI::toString));
        return converters;
    }

    static enum BigDecimalToDecimal128Converter implements Converter<BigDecimal, Decimal128>
    {
        INSTANCE;


        public Decimal128 convert(BigDecimal source) {
            return new Decimal128(source);
        }
    }

    static enum Decimal128ToBigDecimalConverter implements Converter<Decimal128, BigDecimal>
    {
        INSTANCE;


        public BigDecimal convert(Decimal128 source) {
            return source.bigDecimalValue();
        }
    }

    static enum BigIntegerToDecimal128Converter implements Converter<BigInteger, Decimal128>
    {
        INSTANCE;


        public Decimal128 convert(BigInteger source) {
            return new Decimal128(new BigDecimal(source));
        }
    }

    static enum URLToStringConverter implements Converter<URL, String>
    {
        INSTANCE;


        public String convert(URL source) {
            return source.toString();
        }
    }

    static enum StringToURLConverter implements Converter<String, URL>
    {
        INSTANCE;

        private static final TypeDescriptor SOURCE;
        private static final TypeDescriptor TARGET;

        public URL convert(String source) {
            try {
                return new URL(source);
            }
            catch (MalformedURLException e) {
                throw new ConversionFailedException(SOURCE, TARGET, (Object)source, (Throwable)e);
            }
        }

        static {
            SOURCE = TypeDescriptor.valueOf(String.class);
            TARGET = TypeDescriptor.valueOf(URL.class);
        }
    }

    @ReadingConverter
    static enum DocumentToStringConverter implements Converter<Document, String>
    {
        INSTANCE;

        private final Codec<Document> codec = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new Codec<UUID>(){

            public void encode(BsonWriter writer, UUID value, EncoderContext encoderContext) {
                writer.writeString(value.toString());
            }

            public Class<UUID> getEncoderClass() {
                return UUID.class;
            }

            public UUID decode(BsonReader reader, DecoderContext decoderContext) {
                throw new IllegalStateException("decode not supported");
            }
        }}), MongoClientSettings.getDefaultCodecRegistry()}).get(Document.class);

        public String convert(Document source) {
            return source.toJson(this.codec);
        }
    }

    @WritingConverter
    static enum TermToStringConverter implements Converter<Term, String>
    {
        INSTANCE;


        public String convert(Term source) {
            return source.getFormatted();
        }
    }

    static enum NamedMongoScriptToDocumentConverter implements Converter<NamedMongoScript, Document>
    {
        INSTANCE;


        public Document convert(NamedMongoScript source) {
            Document document = new Document();
            document.put(FieldName.ID.name(), (Object)source.getName());
            document.put("value", (Object)new Code(source.getCode()));
            return document;
        }
    }

    static enum DocumentToNamedMongoScriptConverter implements Converter<Document, NamedMongoScript>
    {
        INSTANCE;


        public @Nullable NamedMongoScript convert(Document source) {
            if (source.isEmpty()) {
                return null;
            }
            String id = source.get((Object)FieldName.ID.name()).toString();
            Assert.notNull((Object)id, (String)"Script id must not be null");
            Object rawValue = source.get((Object)"value");
            Assert.isInstanceOf(Code.class, (Object)rawValue);
            return new NamedMongoScript(id, ((Code)rawValue).getCode());
        }
    }

    @WritingConverter
    static enum CurrencyToStringConverter implements Converter<Currency, String>
    {
        INSTANCE;


        public String convert(Currency source) {
            return source.getCurrencyCode();
        }
    }

    @ReadingConverter
    static enum StringToCurrencyConverter implements Converter<String, Currency>
    {
        INSTANCE;


        public @Nullable Currency convert(String source) {
            return StringUtils.hasText((String)source) ? Currency.getInstance(source) : null;
        }
    }

    @WritingConverter
    static enum AtomicIntegerToIntegerConverter implements Converter<AtomicInteger, Integer>
    {
        INSTANCE;


        public Integer convert(AtomicInteger source) {
            return (Integer)NumberUtils.convertNumberToTargetClass((Number)source, Integer.class);
        }
    }

    @WritingConverter
    static enum AtomicLongToLongConverter implements Converter<AtomicLong, Long>
    {
        INSTANCE;


        public Long convert(AtomicLong source) {
            return (Long)NumberUtils.convertNumberToTargetClass((Number)source, Long.class);
        }
    }

    @ReadingConverter
    static enum LongToAtomicLongConverter implements Converter<Long, AtomicLong>
    {
        INSTANCE;


        public AtomicLong convert(Long source) {
            return new AtomicLong(source);
        }
    }

    @ReadingConverter
    static enum IntegerToAtomicIntegerConverter implements Converter<Integer, AtomicInteger>
    {
        INSTANCE;


        public AtomicInteger convert(Integer source) {
            return new AtomicInteger(source);
        }
    }

    @ReadingConverter
    static enum BinaryToByteArrayConverter implements Converter<Binary, byte[]>
    {
        INSTANCE;


        public byte[] convert(Binary source) {
            return source.getData();
        }
    }

    @ReadingConverter
    static enum BsonTimestampToInstantConverter implements Converter<BsonTimestamp, Instant>
    {
        INSTANCE;


        public Instant convert(BsonTimestamp source) {
            return Instant.ofEpochSecond(source.getTime(), 0L);
        }
    }

    @WritingConverter
    static enum NumberToNumberConverterFactory implements ConverterFactory<Number, Number>,
    ConditionalConverter
    {
        INSTANCE;


        public <T extends Number> Converter<Number, T> getConverter(Class<T> targetType) {
            return new NumberToNumberConverter<T>(targetType);
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return !sourceType.equals((Object)targetType);
        }

        private static final class NumberToNumberConverter<T extends Number>
        implements Converter<Number, T> {
            private final Class<T> targetType;

            public NumberToNumberConverter(Class<T> targetType) {
                Assert.notNull(targetType, (String)"Target type must not be null");
                this.targetType = targetType;
            }

            public T convert(Number source) {
                if (source instanceof AtomicInteger) {
                    AtomicInteger atomicInteger = (AtomicInteger)source;
                    return (T)NumberUtils.convertNumberToTargetClass((Number)atomicInteger.get(), this.targetType);
                }
                if (source instanceof AtomicLong) {
                    AtomicLong atomicLong = (AtomicLong)source;
                    return (T)NumberUtils.convertNumberToTargetClass((Number)atomicLong.get(), this.targetType);
                }
                return (T)NumberUtils.convertNumberToTargetClass((Number)source, this.targetType);
            }
        }
    }

    @WritingConverter
    static enum VectorToBsonArrayConverter implements Converter<Vector, Object>
    {
        INSTANCE;


        public Object convert(Vector source) {
            if (source instanceof MongoVector) {
                MongoVector mv = (MongoVector)source;
                return mv.getSource();
            }
            double[] doubleArray = source.toDoubleArray();
            BsonArray array = new BsonArray(doubleArray.length);
            for (double v : doubleArray) {
                array.add((BsonValue)new BsonDouble(v));
            }
            return array;
        }
    }

    @ReadingConverter
    static enum ListToVectorConverter implements Converter<List<Number>, Vector>
    {
        INSTANCE;


        public Vector convert(List<Number> source) {
            return Vector.of(source);
        }
    }

    @ReadingConverter
    static enum BinaryVectorToMongoVectorConverter implements Converter<BinaryVector, Vector>
    {
        INSTANCE;


        public Vector convert(BinaryVector source) {
            return MongoVector.of(source);
        }
    }

    @WritingConverter
    static enum ByteArrayConverterFactory implements ConverterFactory<byte[], Object>,
    ConditionalConverter
    {
        INSTANCE;


        public <T> Converter<byte[], T> getConverter(Class<T> targetType) {
            return new ByteArrayConverter<T>(targetType);
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return targetType.getType() != Object.class && !sourceType.equals((Object)targetType);
        }

        private static final class ByteArrayConverter<T>
        implements Converter<byte[], T> {
            private final Class<T> targetType;

            public ByteArrayConverter(Class<T> targetType) {
                Assert.notNull(targetType, (String)"Target type must not be null");
                this.targetType = targetType;
            }

            public T convert(byte[] source) {
                if (this.targetType == BinaryVector.class) {
                    return (T)BinaryVector.int8Vector((byte[])source);
                }
                return (T)source;
            }
        }
    }

    @ReadingConverter
    static enum StringToBigIntegerConverter implements Converter<String, BigInteger>
    {
        INSTANCE;


        public @Nullable BigInteger convert(String source) {
            return StringUtils.hasText((String)source) ? new BigInteger(source) : null;
        }
    }

    @WritingConverter
    static enum BigIntegerToStringConverter implements Converter<BigInteger, String>
    {
        INSTANCE;


        public String convert(BigInteger source) {
            return source.toString();
        }
    }

    static enum StringToBigDecimalConverter implements Converter<String, BigDecimal>
    {
        INSTANCE;


        public @Nullable BigDecimal convert(String source) {
            return StringUtils.hasText((String)source) ? new BigDecimal(source) : null;
        }
    }

    static enum BigDecimalToStringConverter implements Converter<BigDecimal, String>
    {
        INSTANCE;


        public String convert(BigDecimal source) {
            return source.toString();
        }
    }

    static enum BigIntegerToObjectIdConverter implements Converter<BigInteger, ObjectId>
    {
        INSTANCE;


        public ObjectId convert(BigInteger source) {
            return new ObjectId(source.toString(16));
        }
    }

    static enum ObjectIdToBigIntegerConverter implements Converter<ObjectId, BigInteger>
    {
        INSTANCE;


        public BigInteger convert(ObjectId source) {
            return new BigInteger(source.toString(), 16);
        }
    }

    static enum StringToObjectIdConverter implements Converter<String, ObjectId>
    {
        INSTANCE;


        public @Nullable ObjectId convert(String source) {
            return StringUtils.hasText((String)source) ? new ObjectId(source) : null;
        }
    }

    static enum ObjectIdToStringConverter implements Converter<ObjectId, String>
    {
        INSTANCE;


        public String convert(ObjectId id) {
            return id.toString();
        }
    }
}

