/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.ArithmeticOperators;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.ReplaceWithOperation;
import org.springframework.data.mongodb.core.aggregation.SetOperation;
import org.springframework.data.mongodb.core.aggregation.UnsetOperation;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class AggregationUpdate
extends Aggregation
implements UpdateDefinition {
    private boolean isolated = false;
    private final Set<String> keysTouched = new HashSet<String>();

    protected AggregationUpdate() {
        this(new ArrayList<AggregationOperation>());
    }

    protected AggregationUpdate(List<AggregationOperation> pipeline) {
        super(pipeline);
        for (AggregationOperation operation : pipeline) {
            if (!(operation instanceof FieldsExposingAggregationOperation)) continue;
            FieldsExposingAggregationOperation exposingAggregationOperation = (FieldsExposingAggregationOperation)operation;
            exposingAggregationOperation.getFields().forEach(it -> this.keysTouched.add(it.getName()));
        }
    }

    public static AggregationUpdate update() {
        return new AggregationUpdate();
    }

    public static AggregationUpdate from(List<AggregationOperation> pipeline) {
        return new AggregationUpdate(pipeline);
    }

    @Contract(value="_ -> this")
    public AggregationUpdate set(SetOperation setOperation) {
        Assert.notNull((Object)setOperation, (String)"SetOperation must not be null");
        setOperation.getFields().forEach(it -> this.keysTouched.add(it.getName()));
        this.pipeline.add(setOperation);
        return this;
    }

    @Contract(value="_ -> this")
    public AggregationUpdate unset(UnsetOperation unsetOperation) {
        Assert.notNull((Object)unsetOperation, (String)"UnsetOperation must not be null");
        this.pipeline.add(unsetOperation);
        this.keysTouched.addAll(unsetOperation.removedFieldNames());
        return this;
    }

    @Contract(value="_ -> this")
    public AggregationUpdate replaceWith(ReplaceWithOperation replaceWithOperation) {
        Assert.notNull((Object)replaceWithOperation, (String)"ReplaceWithOperation must not be null");
        this.pipeline.add(replaceWithOperation);
        return this;
    }

    @Contract(value="_ -> this")
    public AggregationUpdate replaceWith(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.replaceWith(ReplaceWithOperation.replaceWithValue(value));
    }

    @Contract(value="_ -> new")
    public SetValueAppender set(final String key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return new SetValueAppender(){
            final /* synthetic */ AggregationUpdate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public AggregationUpdate toValue(@Nullable Object value) {
                return this.this$0.set(SetOperation.builder().set(key).toValue(value));
            }

            @Override
            public AggregationUpdate toValueOf(Object value) {
                Assert.notNull((Object)value, (String)"Value must not be null");
                return this.this$0.set(SetOperation.builder().set(key).toValueOf(value));
            }
        };
    }

    @Contract(value="_ -> this")
    public AggregationUpdate unset(String ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return this.unset(new UnsetOperation(Arrays.stream(keys).map(Fields::field).collect(Collectors.toList())));
    }

    @Contract(value="-> this")
    public AggregationUpdate isolated() {
        this.isolated = true;
        return this;
    }

    @Override
    public Boolean isIsolated() {
        return this.isolated;
    }

    @Override
    public Document getUpdateObject() {
        return new Document("", this.toPipeline(Aggregation.DEFAULT_CONTEXT));
    }

    @Override
    public boolean modifies(String key) {
        return this.keysTouched.contains(key);
    }

    @Override
    public void inc(String key) {
        this.set(new SetOperation(key, ArithmeticOperators.valueOf(key).add(1)));
    }

    @Override
    public List<UpdateDefinition.ArrayFilter> getArrayFilters() {
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(",\n", "[\n", "\n]");
        this.toPipeline(Aggregation.DEFAULT_CONTEXT).stream().map(SerializationUtils::serializeToJsonSafely).forEach(joiner::add);
        return joiner.toString();
    }

    public static interface SetValueAppender {
        public AggregationUpdate toValue(@Nullable Object var1);

        public AggregationUpdate toValueOf(Object var1);
    }
}

