/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.aot;

import com.mongodb.MongoClientSettings;
import com.mongodb.ServerAddress;
import com.mongodb.UnixServerAddress;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.data.mongodb.aot.MongoAotPredicates;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.ReactiveAfterConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.ReactiveAfterSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.ReactiveBeforeConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.ReactiveBeforeSaveCallback;
import org.springframework.util.ClassUtils;

class MongoRuntimeHints
implements RuntimeHintsRegistrar {
    MongoRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        hints.reflection().registerTypes(Arrays.asList(TypeReference.of(BeforeConvertCallback.class), TypeReference.of(BeforeSaveCallback.class), TypeReference.of(AfterConvertCallback.class), TypeReference.of(AfterSaveCallback.class)), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
        MongoRuntimeHints.registerTransactionProxyHints(hints, classLoader);
        MongoRuntimeHints.registerMongoCompatibilityAdapterHints(hints, classLoader);
        if (MongoAotPredicates.isReactorPresent()) {
            hints.reflection().registerTypes(Arrays.asList(TypeReference.of(ReactiveBeforeConvertCallback.class), TypeReference.of(ReactiveBeforeSaveCallback.class), TypeReference.of(ReactiveAfterConvertCallback.class), TypeReference.of(ReactiveAfterSaveCallback.class)), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
        }
    }

    private static void registerTransactionProxyHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        if (MongoAotPredicates.isSyncClientPresent(classLoader) && ClassUtils.isPresent((String)"org.springframework.aop.SpringProxy", (ClassLoader)classLoader)) {
            hints.proxies().registerJdkProxy(new TypeReference[]{TypeReference.of((String)"com.mongodb.client.MongoDatabase"), TypeReference.of((String)"org.springframework.aop.SpringProxy"), TypeReference.of((String)"org.springframework.core.DecoratingProxy")});
            hints.proxies().registerJdkProxy(new TypeReference[]{TypeReference.of((String)"com.mongodb.client.MongoCollection"), TypeReference.of((String)"org.springframework.aop.SpringProxy"), TypeReference.of((String)"org.springframework.core.DecoratingProxy")});
        }
    }

    private static void registerMongoCompatibilityAdapterHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        hints.reflection().registerType(MongoClientSettings.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}).registerType(MongoClientSettings.Builder.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}).registerType(IndexOptions.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}).registerType(ServerAddress.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}).registerType(UnixServerAddress.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}).registerType(TypeReference.of((String)"com.mongodb.connection.StreamFactoryFactory"), new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS}).registerType(TypeReference.of((String)"com.mongodb.internal.connection.StreamFactoryFactory"), new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS}).registerType(TypeReference.of((String)"com.mongodb.internal.build.MongoDriverVersion"), new MemberCategory[]{MemberCategory.PUBLIC_FIELDS});
        if (MongoAotPredicates.isSyncClientPresent(classLoader)) {
            hints.reflection().registerType(MongoDatabase.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}).registerType(TypeReference.of((String)"com.mongodb.client.internal.MongoDatabaseImpl"), new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}).registerType(MapReduceIterable.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}).registerType(TypeReference.of((String)"com.mongodb.client.internal.MapReduceIterableImpl"), new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
        }
        if (MongoAotPredicates.isReactiveClientPresent(classLoader)) {
            hints.reflection().registerType(com.mongodb.reactivestreams.client.MongoDatabase.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}).registerType(TypeReference.of((String)"com.mongodb.reactivestreams.client.internal.MongoDatabaseImpl"), new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}).registerType(MapReducePublisher.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}).registerType(TypeReference.of((String)"com.mongodb.reactivestreams.client.internal.MapReducePublisherImpl"), new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
        }
    }
}

