/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util;

import org.jspecify.annotations.Nullable;
import org.springframework.data.util.Version;
import org.springframework.util.ClassUtils;

public class MongoClientVersion {
    private static final boolean SYNC_CLIENT_PRESENT;
    private static final boolean ASYNC_CLIENT_PRESENT;
    private static final boolean REACTIVE_CLIENT_PRESENT;
    private static final boolean IS_VERSION_5_OR_NEWER;
    private static final Version CLIENT_VERSION;

    public static boolean isAsyncClient() {
        return ASYNC_CLIENT_PRESENT;
    }

    public static boolean isSyncClientPresent() {
        return SYNC_CLIENT_PRESENT;
    }

    public static boolean isReactiveClientPresent() {
        return REACTIVE_CLIENT_PRESENT;
    }

    public static boolean isVersion5orNewer() {
        return IS_VERSION_5_OR_NEWER;
    }

    private static Version getMongoDbDriverVersion(ClassLoader classLoader) {
        Version version = MongoClientVersion.getVersionFromPackage(classLoader);
        return version == null ? MongoClientVersion.guessDriverVersionFromClassPath(classLoader) : version;
    }

    private static @Nullable Version getVersionFromPackage(ClassLoader classLoader) {
        if (ClassUtils.isPresent((String)"com.mongodb.internal.build.MongoDriverVersion", (ClassLoader)classLoader)) {
            try {
                return Version.parse((String)"5.4.0");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Version guessDriverVersionFromClassPath(ClassLoader classLoader) {
        if (ClassUtils.isPresent((String)"com.mongodb.internal.connection.StreamFactoryFactory", (ClassLoader)classLoader)) {
            return Version.parse((String)"5");
        }
        return Version.parse((String)"4.11");
    }

    static {
        Version version;
        SYNC_CLIENT_PRESENT = ClassUtils.isPresent((String)"com.mongodb.MongoClient", (ClassLoader)MongoClientVersion.class.getClassLoader()) || ClassUtils.isPresent((String)"com.mongodb.client.MongoClient", (ClassLoader)MongoClientVersion.class.getClassLoader());
        ASYNC_CLIENT_PRESENT = ClassUtils.isPresent((String)"com.mongodb.async.client.MongoClient", (ClassLoader)MongoClientVersion.class.getClassLoader());
        REACTIVE_CLIENT_PRESENT = ClassUtils.isPresent((String)"com.mongodb.reactivestreams.client.MongoClient", (ClassLoader)MongoClientVersion.class.getClassLoader());
        ClassLoader classLoader = MongoClientVersion.class.getClassLoader();
        CLIENT_VERSION = version = MongoClientVersion.getMongoDbDriverVersion(classLoader);
        IS_VERSION_5_OR_NEWER = CLIENT_VERSION.isGreaterThanOrEqualTo(Version.parse((String)"5.0"));
    }
}

