/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.EmptyCloseableIterator;
import com.querydsl.core.Fetchable;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Window;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbQuerySupport;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbSerializer;
import org.springframework.data.mongodb.repository.util.SliceUtils;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Contract;

public class SpringDataMongodbQuery<T>
extends SpringDataMongodbQuerySupport<SpringDataMongodbQuery<T>>
implements Fetchable<T> {
    private final MongoOperations mongoOperations;
    private final Consumer<BasicQuery> queryCustomizer;
    private final ExecutableFindOperation.FindWithQuery<T> find;

    public SpringDataMongodbQuery(MongoOperations operations, Class<? extends T> type) {
        this(operations, type, operations.getCollectionName(type));
    }

    public SpringDataMongodbQuery(MongoOperations operations, Class<? extends T> type, String collectionName) {
        this(operations, type, type, collectionName, it -> {});
    }

    SpringDataMongodbQuery(MongoOperations operations, Class<?> domainType, Class<? extends T> resultType, String collectionName, Consumer<BasicQuery> queryCustomizer) {
        super(new SpringDataMongodbSerializer(operations.getConverter()));
        Class<? extends T> resultType1 = resultType;
        this.mongoOperations = operations;
        this.queryCustomizer = queryCustomizer;
        this.find = this.mongoOperations.query(domainType).inCollection(collectionName).as(resultType1);
    }

    public CloseableIterator<T> iterate() {
        try {
            final Stream<T> stream = this.stream();
            final Iterator iterator = stream.iterator();
            return new CloseableIterator<T>(){

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public T next() {
                    return iterator.next();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove from iterator while streaming data.");
                }

                public void close() {
                    stream.close();
                }
            };
        }
        catch (RuntimeException e) {
            return (CloseableIterator)SpringDataMongodbQuery.handleException(e, new EmptyCloseableIterator());
        }
    }

    public Window<T> scroll(ScrollPosition scrollPosition) {
        try {
            return this.find.matching(this.createQuery()).scroll(scrollPosition);
        }
        catch (RuntimeException e) {
            return SpringDataMongodbQuery.handleException(e, Window.from(Collections.emptyList(), value -> {
                throw new UnsupportedOperationException();
            }));
        }
    }

    public Stream<T> stream() {
        try {
            return this.find.matching(this.createQuery()).stream();
        }
        catch (RuntimeException e) {
            return SpringDataMongodbQuery.handleException(e, Stream.empty());
        }
    }

    public List<T> fetch() {
        try {
            return this.find.matching(this.createQuery()).all();
        }
        catch (RuntimeException e) {
            return SpringDataMongodbQuery.handleException(e, Collections.emptyList());
        }
    }

    public Page<T> fetchPage(Pageable pageable) {
        try {
            List<T> content = this.find.matching(this.createQuery().with(pageable)).all();
            return PageableExecutionUtils.getPage(content, (Pageable)pageable, this::fetchCount);
        }
        catch (RuntimeException e) {
            return (Page)SpringDataMongodbQuery.handleException(e, new PageImpl(Collections.emptyList(), pageable, 0L));
        }
    }

    public Slice<T> fetchSlice(Pageable pageable) {
        List<T> content = this.find.matching(SliceUtils.limitResult(this.createQuery(), pageable).with(pageable.getSort())).all();
        return SliceUtils.sliceResult(content, pageable);
    }

    public @Nullable T fetchFirst() {
        try {
            return this.find.matching(this.createQuery()).firstValue();
        }
        catch (RuntimeException e) {
            return SpringDataMongodbQuery.handleException(e, null);
        }
    }

    public @Nullable T fetchOne() {
        try {
            return this.find.matching(this.createQuery()).oneValue();
        }
        catch (RuntimeException e) {
            return SpringDataMongodbQuery.handleException(e, null);
        }
    }

    public QueryResults<T> fetchResults() {
        long total = this.fetchCount();
        return total > 0L ? new QueryResults(this.fetch(), this.getQueryMixin().getMetadata().getModifiers(), total) : QueryResults.emptyResults();
    }

    public long fetchCount() {
        try {
            return this.find.matching(Query.of(this.createQuery()).skip(-1L).limit(-1)).count();
        }
        catch (RuntimeException e) {
            return SpringDataMongodbQuery.handleException(e, 0L);
        }
    }

    protected Query createQuery() {
        QueryMetadata metadata = this.getQueryMixin().getMetadata();
        return this.createQuery(this.createFilter(metadata), metadata.getProjection(), metadata.getModifiers(), metadata.getOrderBy());
    }

    protected Query createQuery(@Nullable Predicate filter, @Nullable Expression<?> projection, QueryModifiers modifiers, List<OrderSpecifier<?>> orderBy) {
        Document fields = this.createProjection(projection);
        BasicQuery basicQuery = new BasicQuery(this.createQuery(filter), fields == null ? new Document() : fields);
        Integer limit = modifiers.getLimitAsInteger();
        Integer offset = modifiers.getOffsetAsInteger();
        if (limit != null) {
            basicQuery.limit(limit);
        }
        if (offset != null) {
            basicQuery.skip(offset.intValue());
        }
        if (orderBy.size() > 0) {
            basicQuery.setSortObject(this.createSort(orderBy));
        }
        this.queryCustomizer.accept(basicQuery);
        return basicQuery;
    }

    protected List<Object> getIds(Class<?> targetType, Predicate condition) {
        Query query = this.createQuery(condition, null, QueryModifiers.EMPTY, Collections.emptyList());
        return this.mongoOperations.findDistinct(query, FieldName.ID.name(), targetType, Object.class);
    }

    @Contract(value="_, !null -> !null")
    private static <T> @Nullable T handleException(RuntimeException e, @Nullable T defaultValue) {
        if (e.getClass().getName().endsWith("$NoResults")) {
            return defaultValue;
        }
        throw e;
    }
}

