/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.mongodb.ReadPreference;
import com.mongodb.client.result.DeleteResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.CrudMethodMetadata;
import org.springframework.data.mongodb.repository.support.FetchableFluentQuerySupport;
import org.springframework.data.mongodb.repository.util.SliceUtils;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public class SimpleMongoRepository<T, ID>
implements MongoRepository<T, ID> {
    private @Nullable CrudMethodMetadata crudMethodMetadata;
    private final MongoEntityInformation<T, ID> entityInformation;
    private final MongoOperations mongoOperations;

    public SimpleMongoRepository(MongoEntityInformation<T, ID> metadata, MongoOperations mongoOperations) {
        Assert.notNull(metadata, (String)"MongoEntityInformation must not be null");
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null");
        this.entityInformation = metadata;
        this.mongoOperations = mongoOperations;
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        if (this.entityInformation.isNew(entity)) {
            return this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
        }
        return this.mongoOperations.save(entity, this.entityInformation.getCollectionName());
    }

    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null");
        Streamable source = Streamable.of(entities);
        boolean allNew = source.stream().allMatch(arg_0 -> this.entityInformation.isNew(arg_0));
        if (allNew) {
            List result = source.stream().collect(Collectors.toList());
            return new ArrayList(this.mongoOperations.insert(result, this.entityInformation.getCollectionName()));
        }
        return source.stream().map(this::save).collect(Collectors.toList());
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        Query query = this.getIdQuery(id);
        this.getReadPreference().ifPresent(query::withReadPreference);
        return Optional.ofNullable(this.mongoOperations.findOne(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    public boolean existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        Query query = this.getIdQuery(id);
        this.getReadPreference().ifPresent(query::withReadPreference);
        return this.mongoOperations.exists(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public List<T> findAll() {
        return this.findAll(new Query());
    }

    public List<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Ids of entities not be null");
        return this.findAll(this.getIdQuery(ids));
    }

    public long count() {
        Query query = new Query();
        this.getReadPreference().ifPresent(query::withReadPreference);
        return this.mongoOperations.count(query, this.entityInformation.getCollectionName());
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        Query query = this.getIdQuery(id);
        this.getReadPreference().ifPresent(query::withReadPreference);
        this.mongoOperations.remove(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null");
        DeleteResult deleteResult = this.mongoOperations.remove(entity, this.entityInformation.getCollectionName());
        if (this.entityInformation.isVersioned() && deleteResult.wasAcknowledged() && deleteResult.getDeletedCount() == 0L) {
            throw new OptimisticLockingFailureException(String.format("The entity with id %s with version %s in %s cannot be deleted; Was it modified or deleted in the meantime", this.entityInformation.getId(entity), this.entityInformation.getVersion(entity), this.entityInformation.getCollectionName()));
        }
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null");
        Query query = this.getIdQuery(ids);
        this.getReadPreference().ifPresent(query::withReadPreference);
        this.mongoOperations.remove(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        entities.forEach(this::delete);
    }

    public void deleteAll() {
        Query query = new Query();
        this.getReadPreference().ifPresent(query::withReadPreference);
        this.mongoOperations.remove(query, this.entityInformation.getCollectionName());
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        long count = this.count();
        List<T> list = this.findAll(new Query().with(pageable));
        return new PageImpl(list, pageable, count);
    }

    public List<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        Query query = new Query().with(sort);
        return this.findAll(query);
    }

    @Override
    public <S extends T> S insert(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return this.mongoOperations.insert(entity, this.entityInformation.getCollectionName());
    }

    @Override
    public <S extends T> List<S> insert(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null");
        Collection<S> list = SimpleMongoRepository.toCollection(entities);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<S>(this.mongoOperations.insertAll(list));
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation());
        this.getReadPreference().ifPresent(query::withReadPreference);
        return Optional.ofNullable(this.mongoOperations.findOne(query, example.getProbeType(), this.entityInformation.getCollectionName()));
    }

    @Override
    public <S extends T> List<S> findAll(Example<S> example) {
        return this.findAll((Example)example, Sort.unsorted());
    }

    @Override
    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        Assert.notNull(example, (String)"Sample must not be null");
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation()).with(sort);
        this.getReadPreference().ifPresent(query::withReadPreference);
        return this.mongoOperations.find(query, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        Assert.notNull(example, (String)"Sample must not be null");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation()).with(pageable);
        this.getReadPreference().ifPresent(query::withReadPreference);
        List list = this.mongoOperations.find(query, example.getProbeType(), this.entityInformation.getCollectionName());
        return PageableExecutionUtils.getPage(list, (Pageable)pageable, () -> this.mongoOperations.count(Query.of(query).limit(-1).skip(-1L), example.getProbeType(), this.entityInformation.getCollectionName()));
    }

    public <S extends T> long count(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation());
        this.getReadPreference().ifPresent(query::withReadPreference);
        return this.mongoOperations.count(query, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    public <S extends T> boolean exists(Example<S> example) {
        Assert.notNull(example, (String)"Sample must not be null");
        Query query = new Query(new Criteria().alike(example)).collation(this.entityInformation.getCollation());
        this.getReadPreference().ifPresent(query::withReadPreference);
        return this.mongoOperations.exists(query, example.getProbeType(), this.entityInformation.getCollectionName());
    }

    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(example, (String)"Sample must not be null");
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        return queryFunction.apply(new FluentQueryByExample(example, example.getProbeType()));
    }

    void setRepositoryMethodMetadata(CrudMethodMetadata crudMethodMetadata) {
        this.crudMethodMetadata = crudMethodMetadata;
    }

    private Optional<ReadPreference> getReadPreference() {
        if (this.crudMethodMetadata == null) {
            return Optional.empty();
        }
        return this.crudMethodMetadata.getReadPreference();
    }

    private Query getIdQuery(Object id) {
        return new Query(this.getIdCriteria(id));
    }

    private Criteria getIdCriteria(Object id) {
        return Criteria.where(this.entityInformation.getIdAttribute()).is(id);
    }

    private Query getIdQuery(Iterable<? extends ID> ids) {
        Query query = new Query(new Criteria(this.entityInformation.getIdAttribute()).in(SimpleMongoRepository.toCollection(ids)));
        this.getReadPreference().ifPresent(query::withReadPreference);
        return query;
    }

    private static <E> Collection<E> toCollection(Iterable<E> ids) {
        Collection collection;
        return ids instanceof Collection ? (collection = (Collection)ids) : (Collection)StreamUtils.createStreamFromIterator(ids.iterator()).collect(Collectors.toList());
    }

    private List<T> findAll(@Nullable Query query) {
        if (query == null) {
            return Collections.emptyList();
        }
        this.getReadPreference().ifPresent(query::withReadPreference);
        return this.mongoOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    class FluentQueryByExample<S, T>
    extends FetchableFluentQuerySupport<Example<S>, T> {
        FluentQueryByExample(Example<S> example, Class<T> resultType) {
            this(example, Sort.unsorted(), 0, resultType, Collections.emptyList());
        }

        FluentQueryByExample(Example<S> example, Sort sort, int limit, Class<T> resultType, List<String> fieldsToInclude) {
            super(example, sort, limit, resultType, fieldsToInclude);
        }

        @Override
        protected <R> FluentQueryByExample<S, R> create(Example<S> predicate, Sort sort, int limit, Class<R> resultType, List<String> fieldsToInclude) {
            return new FluentQueryByExample<S, R>(predicate, sort, limit, resultType, fieldsToInclude);
        }

        public @Nullable T oneValue() {
            return this.createQuery().oneValue();
        }

        public @Nullable T firstValue() {
            return this.createQuery().firstValue();
        }

        public List<T> all() {
            return this.createQuery().all();
        }

        public Window<T> scroll(ScrollPosition scrollPosition) {
            return this.createQuery().scroll(scrollPosition);
        }

        public Page<T> page(Pageable pageable) {
            Assert.notNull((Object)pageable, (String)"Pageable must not be null");
            List<T> list = this.createQuery(q -> q.with(pageable)).all();
            return PageableExecutionUtils.getPage(list, (Pageable)pageable, this::count);
        }

        public Slice<T> slice(Pageable pageable) {
            Assert.notNull((Object)pageable, (String)"Pageable must not be null");
            List<T> resultList = this.createQuery(q -> SliceUtils.limitResult(q, pageable).with(pageable.getSort())).all();
            return SliceUtils.sliceResult(resultList, pageable);
        }

        public Stream<T> stream() {
            return this.createQuery().stream();
        }

        public long count() {
            return this.createQuery().count();
        }

        public boolean exists() {
            return this.createQuery().exists();
        }

        private ExecutableFindOperation.TerminatingFind<T> createQuery() {
            return this.createQuery(UnaryOperator.identity());
        }

        private ExecutableFindOperation.TerminatingFind<T> createQuery(UnaryOperator<Query> queryCustomizer) {
            Query query = new Query(new Criteria().alike((Example)this.getPredicate())).collation(SimpleMongoRepository.this.entityInformation.getCollation());
            if (this.getSort().isSorted()) {
                query.with(this.getSort());
            }
            query.limit(this.getLimit());
            if (!this.getFieldsToInclude().isEmpty()) {
                query.fields().include(this.getFieldsToInclude());
            }
            SimpleMongoRepository.this.getReadPreference().ifPresent(query::withReadPreference);
            query = (Query)queryCustomizer.apply(query);
            return SimpleMongoRepository.this.mongoOperations.query(((Example)this.getPredicate()).getProbeType()).inCollection(SimpleMongoRepository.this.entityInformation.getCollectionName()).as(this.getResultType()).matching(query);
        }
    }
}

