/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.bson.Document;
import org.bson.json.JsonParseException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryCreator;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.StringUtils;

public class PartTreeMongoQuery
extends AbstractMongoQuery {
    private final PartTree tree;
    private final boolean isGeoNearQuery;
    private final MappingContext<?, MongoPersistentProperty> context;
    private final ResultProcessor processor;

    public PartTreeMongoQuery(MongoQueryMethod method, MongoOperations mongoOperations, ValueExpressionDelegate delegate) {
        super(method, mongoOperations, delegate);
        this.processor = method.getResultProcessor();
        this.tree = new PartTree(method.getName(), this.processor.getReturnedType().getDomainType());
        this.isGeoNearQuery = method.isGeoNearQuery();
        this.context = mongoOperations.getConverter().getMappingContext();
    }

    public PartTree getTree() {
        return this.tree;
    }

    @Override
    protected Query createQuery(ConvertingParameterAccessor accessor) {
        String fieldSpec;
        TextCriteria textCriteria;
        MongoQueryCreator creator = new MongoQueryCreator(this.tree, accessor, this.context, this.isGeoNearQuery);
        Query query = (Query)creator.createQuery();
        if (this.tree.isLimiting()) {
            query.limit(this.tree.getMaxResults());
        }
        if ((textCriteria = accessor.getFullText()) != null) {
            query.addCriteria(textCriteria);
        }
        if (!StringUtils.hasText((String)(fieldSpec = this.getQueryMethod().getFieldSpecification()))) {
            ReturnedType returnedType = this.processor.withDynamicProjection((ParameterAccessor)accessor).getReturnedType();
            if (returnedType.needsCustomConstruction()) {
                Field fields = query.fields();
                for (String field : returnedType.getInputProperties()) {
                    fields.include(field);
                }
            }
            return query;
        }
        try {
            BasicQuery result = new BasicQuery(query.getQueryObject(), Document.parse((String)fieldSpec));
            result.setSortObject(query.getSortObject());
            return result;
        }
        catch (JsonParseException o_O) {
            throw new IllegalStateException(String.format("Invalid query or field specification in %s", new Object[]{this.getQueryMethod()}), o_O);
        }
    }

    @Override
    protected Query createCountQuery(ConvertingParameterAccessor accessor) {
        return (Query)new MongoQueryCreator(this.tree, accessor, this.context, false).createQuery();
    }

    @Override
    protected boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    protected boolean isLimiting() {
        return this.tree.isLimiting();
    }
}

