/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.messaging.Message;
import org.springframework.util.ClassUtils;

class LazyMappingDelegatingMessage<S, T>
implements Message<S, T> {
    private final Message<S, ?> delegate;
    private final Class<T> targetType;
    private final MongoConverter converter;

    LazyMappingDelegatingMessage(Message<S, ?> delegate, Class<T> targetType, MongoConverter converter) {
        this.delegate = delegate;
        this.targetType = targetType;
        this.converter = converter;
    }

    @Override
    public @Nullable S getRaw() {
        return this.delegate.getRaw();
    }

    @Override
    public @Nullable T getBody() {
        if (this.delegate.getBody() == null || this.targetType.equals(this.delegate.getBody().getClass())) {
            return this.targetType.cast(this.delegate.getBody());
        }
        Object messageBody = this.delegate.getBody();
        if (ClassUtils.isAssignable(Document.class, messageBody.getClass())) {
            return (T)this.converter.read(this.targetType, (Document)messageBody);
        }
        if (this.converter.getConversionService().canConvert(messageBody.getClass(), this.targetType)) {
            return (T)this.converter.getConversionService().convert(messageBody, this.targetType);
        }
        throw new IllegalArgumentException(String.format("No converter found capable of converting %s to %s", messageBody.getClass(), this.targetType));
    }

    @Override
    public Message.MessageProperties getProperties() {
        return this.delegate.getProperties();
    }

    public String toString() {
        return "LazyMappingDelegatingMessage(delegate=" + this.delegate + ", targetType=" + this.targetType + ")";
    }
}

