/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import org.bson.BinaryVector;
import org.bson.Float32BinaryVector;
import org.bson.Int8BinaryVector;
import org.bson.PackedBitBinaryVector;
import org.springframework.data.domain.Vector;
import org.springframework.util.ObjectUtils;

public class MongoVector
implements Vector {
    private final BinaryVector v;

    MongoVector(BinaryVector v) {
        this.v = v;
    }

    public static MongoVector of(BinaryVector v) {
        return new MongoVector(v);
    }

    public Class<? extends Number> getType() {
        if (this.v instanceof Float32BinaryVector) {
            return Float.class;
        }
        if (this.v instanceof Int8BinaryVector) {
            return Byte.class;
        }
        if (this.v instanceof PackedBitBinaryVector) {
            return Byte.class;
        }
        return Number.class;
    }

    public BinaryVector getSource() {
        return this.v;
    }

    public int size() {
        BinaryVector binaryVector = this.v;
        if (binaryVector instanceof Float32BinaryVector) {
            Float32BinaryVector f = (Float32BinaryVector)binaryVector;
            return f.getData().length;
        }
        binaryVector = this.v;
        if (binaryVector instanceof Int8BinaryVector) {
            Int8BinaryVector i = (Int8BinaryVector)binaryVector;
            return i.getData().length;
        }
        binaryVector = this.v;
        if (binaryVector instanceof PackedBitBinaryVector) {
            PackedBitBinaryVector p = (PackedBitBinaryVector)binaryVector;
            return p.getData().length;
        }
        return 0;
    }

    public float[] toFloatArray() {
        Object result;
        BinaryVector binaryVector = this.v;
        if (binaryVector instanceof Float32BinaryVector) {
            Float32BinaryVector f = (Float32BinaryVector)binaryVector;
            result = new float[f.getData().length];
            System.arraycopy(f.getData(), 0, result, 0, ((BinaryVector)result).length);
            return result;
        }
        result = this.v;
        if (result instanceof Int8BinaryVector) {
            Int8BinaryVector i = (Int8BinaryVector)result;
            result = new float[i.getData().length];
            System.arraycopy(i.getData(), 0, result, 0, ((BinaryVector)result).length);
            return result;
        }
        return new float[this.size()];
    }

    public double[] toDoubleArray() {
        Object data;
        BinaryVector binaryVector = this.v;
        if (binaryVector instanceof Float32BinaryVector) {
            Float32BinaryVector f = (Float32BinaryVector)binaryVector;
            data = f.getData();
            double[] result = new double[((BinaryVector)data).length];
            for (int i = 0; i < ((BinaryVector)data).length; ++i) {
                result[i] = (double)data[i];
            }
            return result;
        }
        data = this.v;
        if (data instanceof Int8BinaryVector) {
            Int8BinaryVector i = (Int8BinaryVector)data;
            double[] result = new double[i.getData().length];
            System.arraycopy(i.getData(), 0, result, 0, result.length);
            return result;
        }
        return new double[this.size()];
    }

    public boolean equals(Object o) {
        if (!(o instanceof MongoVector)) {
            return false;
        }
        MongoVector that = (MongoVector)o;
        return ObjectUtils.nullSafeEquals((Object)this.v, (Object)that.v);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.v);
    }

    public String toString() {
        return "MV[" + this.v + "]";
    }
}

