/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OutOperation
implements AggregationOperation {
    private final @Nullable String databaseName;
    private final String collectionName;
    private final @Nullable Document uniqueKey;
    private final @Nullable OutMode mode;

    public OutOperation(String outCollectionName) {
        this(null, outCollectionName, null, null);
    }

    private OutOperation(@Nullable String databaseName, String collectionName, @Nullable Document uniqueKey, @Nullable OutMode mode) {
        Assert.notNull((Object)collectionName, (String)"Collection name must not be null");
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.uniqueKey = uniqueKey;
        this.mode = mode;
    }

    @Contract(value="_ -> new")
    public OutOperation in(@Nullable String database) {
        return new OutOperation(database, this.collectionName, this.uniqueKey, this.mode);
    }

    @Contract(value="_ -> new")
    public OutOperation uniqueKey(@Nullable String key) {
        Document uniqueKey = key == null ? null : BsonUtils.toDocumentOrElse(key, it -> new Document(it, (Object)1));
        return new OutOperation(this.databaseName, this.collectionName, uniqueKey, this.mode);
    }

    @Contract(value="_ -> new")
    public OutOperation uniqueKeyOf(Iterable<String> fields) {
        Assert.notNull(fields, (String)"Fields must not be null");
        Document uniqueKey = new Document();
        fields.forEach(it -> uniqueKey.append(it, (Object)1));
        return new OutOperation(this.databaseName, this.collectionName, uniqueKey, this.mode);
    }

    @Contract(value="_ -> new")
    public OutOperation mode(OutMode mode) {
        Assert.notNull((Object)((Object)mode), (String)"Mode must not be null");
        return new OutOperation(this.databaseName, this.collectionName, this.uniqueKey, mode);
    }

    @Contract(value="-> new")
    public OutOperation replaceCollection() {
        return this.mode(OutMode.REPLACE_COLLECTION);
    }

    @Contract(value="-> new")
    public OutOperation replaceDocuments() {
        return this.mode(OutMode.REPLACE);
    }

    @Contract(value="-> new")
    public OutOperation insertDocuments() {
        return this.mode(OutMode.INSERT);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        if (!this.requiresMongoDb42Format()) {
            return new Document("$out", (Object)this.collectionName);
        }
        Assert.state((this.mode != null ? 1 : 0) != 0, (String)"Mode must not be null");
        Document $out = new Document("to", (Object)this.collectionName).append("mode", (Object)this.mode.getMongoMode());
        if (StringUtils.hasText((String)this.databaseName)) {
            $out.append("db", (Object)this.databaseName);
        }
        if (this.uniqueKey != null) {
            $out.append("uniqueKey", (Object)this.uniqueKey);
        }
        return new Document(this.getOperator(), (Object)$out);
    }

    @Override
    public String getOperator() {
        return "$out";
    }

    private boolean requiresMongoDb42Format() {
        return StringUtils.hasText((String)this.databaseName) || this.mode != null || this.uniqueKey != null;
    }

    public static enum OutMode {
        INSERT("insertDocuments"),
        REPLACE("replaceDocuments"),
        REPLACE_COLLECTION("replaceCollection");

        private final String mode;

        private OutMode(String mode) {
            this.mode = mode;
        }

        public String getMongoMode() {
            return this.mode;
        }
    }
}

