/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoException;
import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoResourceHolder;
import org.springframework.data.mongodb.MongoTransactionOptions;
import org.springframework.data.mongodb.MongoTransactionOptionsResolver;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronizationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MongoTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private @Nullable MongoDatabaseFactory databaseFactory;
    private MongoTransactionOptions options;
    private final MongoTransactionOptionsResolver transactionOptionsResolver;

    public MongoTransactionManager() {
        this.transactionOptionsResolver = MongoTransactionOptionsResolver.defaultResolver();
        this.options = MongoTransactionOptions.NONE;
    }

    public MongoTransactionManager(MongoDatabaseFactory databaseFactory) {
        this(databaseFactory, null);
    }

    public MongoTransactionManager(MongoDatabaseFactory databaseFactory, @Nullable TransactionOptions options) {
        this(databaseFactory, MongoTransactionOptionsResolver.defaultResolver(), MongoTransactionOptions.of(options));
    }

    public MongoTransactionManager(MongoDatabaseFactory databaseFactory, MongoTransactionOptionsResolver transactionOptionsResolver, MongoTransactionOptions defaultTransactionOptions) {
        Assert.notNull((Object)databaseFactory, (String)"MongoDatabaseFactory must not be null");
        Assert.notNull((Object)transactionOptionsResolver, (String)"MongoTransactionOptionsResolver must not be null");
        this.databaseFactory = databaseFactory;
        this.transactionOptionsResolver = transactionOptionsResolver;
        this.options = defaultTransactionOptions;
    }

    protected Object doGetTransaction() throws TransactionException {
        MongoResourceHolder resourceHolder = (MongoResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getRequiredDbFactory()));
        return new MongoTransactionObject(resourceHolder);
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        return MongoTransactionManager.extractMongoTransaction(transaction).hasResourceHolder();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        MongoTransactionObject mongoTransactionObject = MongoTransactionManager.extractMongoTransaction(transaction);
        MongoResourceHolder resourceHolder = this.newResourceHolder(definition, ClientSessionOptions.builder().causallyConsistent(true).build());
        mongoTransactionObject.setResourceHolder(resourceHolder);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("About to start transaction for session %s.", MongoTransactionManager.debugString(resourceHolder.getSession())));
        }
        try {
            MongoTransactionOptions mongoTransactionOptions = this.transactionOptionsResolver.resolve(definition).mergeWith(this.options);
            mongoTransactionObject.startTransaction(mongoTransactionOptions.toDriverOptions());
        }
        catch (MongoException ex) {
            throw new TransactionSystemException(String.format("Could not start Mongo transaction for session %s.", MongoTransactionManager.debugString(mongoTransactionObject.getSession())), (Throwable)ex);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Started transaction for session %s.", MongoTransactionManager.debugString(resourceHolder.getSession())));
        }
        resourceHolder.setSynchronizedWithTransaction(true);
        TransactionSynchronizationManager.bindResource((Object)this.getRequiredDbFactory(), (Object)((Object)resourceHolder));
    }

    protected Object doSuspend(Object transaction) throws TransactionException {
        MongoTransactionObject mongoTransactionObject = MongoTransactionManager.extractMongoTransaction(transaction);
        mongoTransactionObject.setResourceHolder(null);
        return TransactionSynchronizationManager.unbindResource((Object)this.getRequiredDbFactory());
    }

    protected void doResume(@Nullable Object transaction, Object suspendedResources) {
        TransactionSynchronizationManager.bindResource((Object)this.getRequiredDbFactory(), (Object)suspendedResources);
    }

    protected final void doCommit(DefaultTransactionStatus status) throws TransactionException {
        MongoTransactionObject mongoTransactionObject = MongoTransactionManager.extractMongoTransaction(status);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("About to commit transaction for session %s.", MongoTransactionManager.debugString(mongoTransactionObject.getSession())));
        }
        try {
            this.doCommit(mongoTransactionObject);
        }
        catch (Exception ex) {
            throw new TransactionSystemException(String.format("Could not commit Mongo transaction for session %s.", MongoTransactionManager.debugString(mongoTransactionObject.getSession())), (Throwable)ex);
        }
    }

    protected void doCommit(MongoTransactionObject transactionObject) throws Exception {
        transactionObject.commitTransaction();
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        MongoTransactionObject mongoTransactionObject = MongoTransactionManager.extractMongoTransaction(status);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("About to abort transaction for session %s.", MongoTransactionManager.debugString(mongoTransactionObject.getSession())));
        }
        try {
            mongoTransactionObject.abortTransaction();
        }
        catch (MongoException ex) {
            throw new TransactionSystemException(String.format("Could not abort Mongo transaction for session %s.", MongoTransactionManager.debugString(mongoTransactionObject.getSession())), (Throwable)ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        MongoTransactionObject transactionObject = MongoTransactionManager.extractMongoTransaction(status);
        transactionObject.getRequiredResourceHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        Assert.isInstanceOf(MongoTransactionObject.class, (Object)transaction, () -> String.format("Expected to find a %s but it turned out to be %s.", MongoTransactionObject.class, transaction.getClass()));
        MongoTransactionObject mongoTransactionObject = (MongoTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource((Object)this.getRequiredDbFactory());
        mongoTransactionObject.getRequiredResourceHolder().clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("About to release Session %s after transaction.", MongoTransactionManager.debugString(mongoTransactionObject.getSession())));
        }
        mongoTransactionObject.closeSession();
    }

    public void setDatabaseFactory(MongoDatabaseFactory databaseFactory) {
        Assert.notNull((Object)databaseFactory, (String)"DbFactory must not be null");
        this.databaseFactory = databaseFactory;
    }

    public void setOptions(@Nullable TransactionOptions options) {
        this.options = MongoTransactionOptions.of(options);
    }

    public @Nullable MongoDatabaseFactory getDatabaseFactory() {
        return this.databaseFactory;
    }

    public MongoDatabaseFactory getResourceFactory() {
        return this.getRequiredDbFactory();
    }

    public void afterPropertiesSet() {
        this.getRequiredDbFactory();
    }

    private MongoResourceHolder newResourceHolder(TransactionDefinition definition, ClientSessionOptions options) {
        MongoDatabaseFactory dbFactory = this.getResourceFactory();
        MongoResourceHolder resourceHolder = new MongoResourceHolder(dbFactory.getSession(options), dbFactory);
        resourceHolder.setTimeoutIfNotDefaulted(this.determineTimeout(definition));
        return resourceHolder;
    }

    private MongoDatabaseFactory getRequiredDbFactory() {
        Assert.state((this.databaseFactory != null ? 1 : 0) != 0, (String)"MongoTransactionManager operates upon a MongoDbFactory; Did you forget to provide one; It's required");
        return this.databaseFactory;
    }

    private static MongoTransactionObject extractMongoTransaction(Object transaction) {
        Assert.isInstanceOf(MongoTransactionObject.class, (Object)transaction, () -> String.format("Expected to find a %s but it turned out to be %s.", MongoTransactionObject.class, transaction.getClass()));
        return (MongoTransactionObject)transaction;
    }

    private static MongoTransactionObject extractMongoTransaction(DefaultTransactionStatus status) {
        Assert.isInstanceOf(MongoTransactionObject.class, (Object)status.getTransaction(), () -> String.format("Expected to find a %s but it turned out to be %s.", MongoTransactionObject.class, status.getTransaction().getClass()));
        return (MongoTransactionObject)status.getTransaction();
    }

    private static String debugString(@Nullable ClientSession session) {
        if (session == null) {
            return "null";
        }
        Object debugString = String.format("[%s@%s ", ClassUtils.getShortName(session.getClass()), Integer.toHexString(session.hashCode()));
        try {
            if (session.getServerSession() != null) {
                debugString = (String)debugString + String.format("id = %s, ", session.getServerSession().getIdentifier());
                debugString = (String)debugString + String.format("causallyConsistent = %s, ", session.isCausallyConsistent());
                debugString = (String)debugString + String.format("txActive = %s, ", session.hasActiveTransaction());
                debugString = (String)debugString + String.format("txNumber = %d, ", session.getServerSession().getTransactionNumber());
                debugString = (String)debugString + String.format("closed = %b, ", session.getServerSession().isClosed());
                debugString = (String)debugString + String.format("clusterTime = %s", session.getClusterTime());
            } else {
                debugString = (String)debugString + "id = n/a";
                debugString = (String)debugString + String.format("causallyConsistent = %s, ", session.isCausallyConsistent());
                debugString = (String)debugString + String.format("txActive = %s, ", session.hasActiveTransaction());
                debugString = (String)debugString + String.format("clusterTime = %s", session.getClusterTime());
            }
        }
        catch (RuntimeException e) {
            debugString = (String)debugString + String.format("error = %s", e.getMessage());
        }
        debugString = (String)debugString + "]";
        return debugString;
    }

    protected static class MongoTransactionObject
    implements SmartTransactionObject {
        private @Nullable MongoResourceHolder resourceHolder;

        MongoTransactionObject(@Nullable MongoResourceHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        void setResourceHolder(@Nullable MongoResourceHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        final boolean hasResourceHolder() {
            return this.resourceHolder != null;
        }

        void startTransaction(@Nullable TransactionOptions options) {
            ClientSession session = this.getRequiredSession();
            if (options != null) {
                session.startTransaction(options);
            } else {
                session.startTransaction();
            }
        }

        public void commitTransaction() {
            this.getRequiredSession().commitTransaction();
        }

        public void abortTransaction() {
            this.getRequiredSession().abortTransaction();
        }

        void closeSession() {
            ClientSession session = this.getRequiredSession();
            if (session.getServerSession() != null && !session.getServerSession().isClosed()) {
                session.close();
            }
        }

        public @Nullable ClientSession getSession() {
            return this.resourceHolder != null ? this.resourceHolder.getSession() : null;
        }

        private MongoResourceHolder getRequiredResourceHolder() {
            Assert.state((this.resourceHolder != null ? 1 : 0) != 0, (String)"MongoResourceHolder is required but not present; o_O");
            return this.resourceHolder;
        }

        private ClientSession getRequiredSession() {
            ClientSession session = this.getSession();
            Assert.state((session != null ? 1 : 0) != 0, (String)"A Session is required but it turned out to be null");
            return session;
        }

        public boolean isRollbackOnly() {
            return this.resourceHolder != null && this.resourceHolder.isRollbackOnly();
        }

        public void flush() {
            TransactionSynchronizationUtils.triggerFlush();
        }
    }
}

