/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.core.annotation.AliasFor;
import org.springframework.data.mongodb.core.annotation.Collation;
import org.springframework.data.mongodb.core.index.IndexDirection;

@Collation
@Target(value={ElementType.ANNOTATION_TYPE, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Indexed {
    public boolean unique() default false;

    public IndexDirection direction() default IndexDirection.ASCENDING;

    public boolean sparse() default false;

    public String name() default "";

    public boolean useGeneratedName() default false;

    public boolean background() default false;

    @Deprecated(since="4.4", forRemoval=true)
    public int expireAfterSeconds() default -1;

    public String expireAfter() default "";

    public String partialFilter() default "";

    @AliasFor(annotation=Collation.class, attribute="value")
    public String collation() default "";
}

