/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.validation;

import org.bson.Document;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.data.mongodb.core.validation.Validator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class JsonSchemaValidator
implements Validator {
    private final MongoJsonSchema schema;

    private JsonSchemaValidator(MongoJsonSchema schema) {
        this.schema = schema;
    }

    static JsonSchemaValidator of(MongoJsonSchema schema) {
        Assert.notNull((Object)schema, (String)"Schema must not be null");
        return new JsonSchemaValidator(schema);
    }

    @Override
    public Document toDocument() {
        return this.schema.toDocument();
    }

    public String toString() {
        return SerializationUtils.serializeToJsonSafely(this.toDocument());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaValidator that = (JsonSchemaValidator)o;
        return ObjectUtils.nullSafeEquals((Object)this.schema, (Object)that.schema);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.schema);
    }
}

