/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.HashMap;
import java.util.Map;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Field {
    private final Map<String, Integer> criteria = new HashMap<String, Integer>();
    private final Map<String, Object> slices = new HashMap<String, Object>();
    private final Map<String, Criteria> elemMatchs = new HashMap<String, Criteria>();
    @Nullable
    private String positionKey;
    private int positionValue;

    public Field include(String key) {
        this.criteria.put(key, 1);
        return this;
    }

    public Field exclude(String key) {
        this.criteria.put(key, 0);
        return this;
    }

    public Field slice(String key, int size) {
        this.slices.put(key, size);
        return this;
    }

    public Field slice(String key, int offset, int size) {
        this.slices.put(key, new Integer[]{offset, size});
        return this;
    }

    public Field elemMatch(String key, Criteria elemMatchCriteria) {
        this.elemMatchs.put(key, elemMatchCriteria);
        return this;
    }

    public Field position(String field, int value) {
        Assert.hasText((String)field, (String)"DocumentField must not be null or empty!");
        this.positionKey = field;
        this.positionValue = value;
        return this;
    }

    public Document getFieldsObject() {
        Document document = new Document(this.criteria);
        for (Map.Entry<String, Object> entry : this.slices.entrySet()) {
            document.put(entry.getKey(), (Object)new Document("$slice", entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.elemMatchs.entrySet()) {
            document.put(entry.getKey(), (Object)new Document("$elemMatch", (Object)((Criteria)entry.getValue()).getCriteriaObject()));
        }
        if (this.positionKey != null) {
            document.put(this.positionKey + ".$", (Object)this.positionValue);
        }
        return document;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        if (this.positionValue != field.positionValue) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.criteria, field.criteria)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.slices, field.slices)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.elemMatchs, field.elemMatchs)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.positionKey, (Object)field.positionKey);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.criteria);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.slices);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.elemMatchs);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.positionKey);
        result = 31 * result + this.positionValue;
        return result;
    }
}

